/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.Component;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.ComponentLike;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.MiniMessageImpl;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.Template;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.markdown.MarkdownFlavor;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.transformation.TransformationRegistry;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.transformation.TransformationType;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.serializer.ComponentSerializer;
import xyz.derkades.serverselectorx.lib.kyori.adventure.util.Buildable;

public interface MiniMessage
extends ComponentSerializer<Component, Component, String>,
Buildable<MiniMessage, Builder> {
    public static @NonNull MiniMessage get() {
        return MiniMessageImpl.INSTANCE;
    }

    public static @NonNull MiniMessage markdown() {
        return MiniMessageImpl.MARKDOWN;
    }

    public static @NonNull MiniMessage withMarkdownFlavor(MarkdownFlavor markdownFlavor) {
        return new MiniMessageImpl(true, markdownFlavor, new TransformationRegistry(), MiniMessageImpl.DEFAULT_PLACEHOLDER_RESOLVER, false, MiniMessageImpl.DEFAULT_ERROR_CONSUMER);
    }

    @SafeVarargs
    public static @NonNull MiniMessage withTransformations(TransformationType<? extends Transformation> ... types) {
        return new MiniMessageImpl(false, MarkdownFlavor.defaultFlavor(), new TransformationRegistry(types), MiniMessageImpl.DEFAULT_PLACEHOLDER_RESOLVER, false, MiniMessageImpl.DEFAULT_ERROR_CONSUMER);
    }

    @SafeVarargs
    public static @NonNull MiniMessage markdownWithTransformations(TransformationType<? extends Transformation> ... types) {
        return new MiniMessageImpl(true, MarkdownFlavor.defaultFlavor(), new TransformationRegistry(types), MiniMessageImpl.DEFAULT_PLACEHOLDER_RESOLVER, false, MiniMessageImpl.DEFAULT_ERROR_CONSUMER);
    }

    @SafeVarargs
    public static @NonNull MiniMessage markdownWithTransformations(MarkdownFlavor markdownFlavor, TransformationType<? extends Transformation> ... types) {
        return new MiniMessageImpl(true, markdownFlavor, new TransformationRegistry(types), MiniMessageImpl.DEFAULT_PLACEHOLDER_RESOLVER, false, MiniMessageImpl.DEFAULT_ERROR_CONSUMER);
    }

    public @NonNull String escapeTokens(@NonNull String var1);

    public @NonNull String stripTokens(@NonNull String var1);

    default public Component parse(@NonNull String input) {
        return this.deserialize(input);
    }

    public @NonNull Component parse(@NonNull String var1, String ... var2);

    public @NonNull Component parse(@NonNull String var1, @NonNull Map<String, String> var2);

    public @NonNull Component parse(@NonNull String var1, Object ... var2);

    public @NonNull Component parse(@NonNull String var1, Template ... var2);

    public @NonNull Component parse(@NonNull String var1, @NonNull List<Template> var2);

    public static Builder builder() {
        return new MiniMessageImpl.BuilderImpl();
    }

    public static interface Builder
    extends Buildable.Builder<MiniMessage> {
        public @NonNull Builder markdown();

        public @NonNull Builder removeDefaultTransformations();

        public @NonNull Builder transformation(TransformationType<? extends Transformation> var1);

        public @NonNull Builder transformations(TransformationType<? extends Transformation> ... var1);

        public @NonNull Builder markdownFlavor(MarkdownFlavor var1);

        public @NonNull Builder placeholderResolver(Function<String, ComponentLike> var1);

        public @NonNull Builder strict(boolean var1);

        public @NonNull Builder parsingErrorMessageConsumer(Consumer<List<String>> var1);

        @Override
        public @NonNull MiniMessage build();
    }
}

