/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.placeholders;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.placeholders.GlobalPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Placeholder;
import xyz.derkades.serverselectorx.placeholders.PlayerPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Server;

public class PapiExpansion
extends PlaceholderExpansion {
    public String onPlaceholderRequest(Player player, String identifier) {
        if (identifier.startsWith("server_")) {
            identifier = identifier.substring(7);
            StringBuilder serverName = new StringBuilder();
            for (char c : identifier.toCharArray()) {
                if (c == '_') break;
                serverName.append(c);
            }
            String placeholderName = identifier.substring(serverName.length() + 1);
            Server server = Server.getServer(serverName.toString());
            if (placeholderName.equals("status")) {
                return Main.getConfigurationManager().getMiscConfiguration().getString("placeholders.status-" + (server.isOnline() ? "online" : "offline"), server.isOnline() ? "online" : "offline");
            }
            Placeholder placeholder = server.getPlaceholder(placeholderName);
            if (placeholder instanceof PlayerPlaceholder) {
                return ((PlayerPlaceholder)placeholder).getValue((OfflinePlayer)player);
            }
            return ((GlobalPlaceholder)placeholder).getValue();
        }
        return null;
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", Main.getPlugin().getDescription().getAuthors());
    }

    @NotNull
    public String getIdentifier() {
        return "ssx";
    }

    @NotNull
    public String getVersion() {
        return Main.getPlugin().getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }
}

