/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.lang.reflect.InvocationTargetException;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTItem;

public class ItemGiveListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        FileConfiguration config = Main.getConfigurationManager().getInventoryConfiguration();
        if (config.getBoolean("clear-inv", false) && !player.hasPermission("ssx.clearinvbypass")) {
            this.debug("Clearning inventory for " + player.getName());
            PlayerInventory inv = player.getInventory();
            inv.setContents(new ItemStack[inv.getContents().length]);
            try {
                int length = ((ItemStack[])inv.getClass().getMethod("getStorageContents", new Class[0]).invoke((Object)inv, new Object[0])).length;
                inv.getClass().getMethod("setStorageContents", ItemStack[].class).invoke((Object)inv, new Object[]{new ItemStack[length]});
            }
            catch (NoSuchMethodException length) {
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
            inv.setArmorContents(new ItemStack[inv.getArmorContents().length]);
        }
        this.giveItems(player, "join");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onWorldChange(PlayerChangedWorldEvent event) {
        this.giveItems(event.getPlayer(), "world-switch");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onRespawn(PlayerRespawnEvent event) {
        this.giveItems(event.getPlayer(), "death");
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onClear(PlayerCommandPreprocessEvent event) {
        if (event.getMessage().equals("/clear") && event.getPlayer().hasPermission("minecraft.command.clear")) {
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getPlugin(), () -> this.giveItems(event.getPlayer(), "clear"), 1L);
        }
    }

    private void removeSsxItems(ItemStack[] contents) {
        for (int i = 0; i < contents.length; ++i) {
            NBTItem nbt;
            ItemStack item = contents[i];
            if (item == null || item.getType() == Material.AIR || !(nbt = new NBTItem(item)).hasKey("SSXItem").booleanValue()) continue;
            this.debug("Removed item at position " + i);
            contents[i] = null;
        }
    }

    public void giveItems(Player player, String type) {
        this.debug("Giving items to " + player.getName() + ". Reason: " + type);
        this.debug("First removing any existing SSX items");
        PlayerInventory inv = player.getInventory();
        ItemStack[] contents = inv.getContents();
        ItemStack[] armorContents = inv.getArmorContents();
        this.removeSsxItems(contents);
        this.removeSsxItems(armorContents);
        inv.setContents(contents);
        inv.setArmorContents(armorContents);
        this.debug("Now giving items");
        for (String name : Main.getConfigurationManager().listItemConfigurations()) {
            ItemStack itemF;
            FileConfiguration config = Main.getConfigurationManager().getItemConfiguration(name);
            this.debug("Preparing to give item '" + name + "'");
            if (!config.getBoolean("give." + type)) {
                this.debug("Item skipped, give is disabled");
                continue;
            }
            if (config.getBoolean("give.permission")) {
                this.debug("Permissions are enabled, checking permission");
                String permission = "ssx.item." + name;
                if (!player.hasPermission(permission)) {
                    this.debug("Player does not have permission '" + permission + "', skipping item");
                    continue;
                }
            }
            if (config.isList("worlds")) {
                this.debug("World whitelisting is enabled");
                if (!config.getStringList("worlds").contains(player.getWorld().getName())) {
                    this.debug("Player is in a world that is not whitelisted (" + player.getWorld().getName() + ")");
                    continue;
                }
            }
            this.debug("All checks done, giving item");
            if (!config.isConfigurationSection("item")) {
                player.sendMessage("Missing 'item' section in item config '" + name + "'");
                continue;
            }
            ItemStack item = Main.getItemBuilderFromItemSection(player, config.getConfigurationSection("item")).create();
            NBTItem nbt = new NBTItem(item);
            nbt.setString("SSXItem", name);
            item = nbt.getItem();
            int slot = config.getInt("give.inv-slot", 0);
            int delay = config.getInt("give.delay", 0);
            this.debug("Give delay: " + delay);
            if (slot < 0) {
                if (inv.containsAtLeast(item, item.getAmount())) continue;
                if (delay == 0) {
                    inv.addItem(new ItemStack[]{item});
                    continue;
                }
                itemF = item;
                Bukkit.getScheduler().runTaskLater((Plugin)Main.getPlugin(), () -> inv.addItem(new ItemStack[]{itemF}), (long)delay);
                continue;
            }
            if (delay == 0) {
                inv.setItem(slot, item);
                continue;
            }
            itemF = item;
            Bukkit.getScheduler().runTaskLater((Plugin)Main.getPlugin(), () -> inv.setItem(slot, itemF), (long)delay);
        }
    }

    private void debug(String message) {
        if (Main.ITEM_DEBUG) {
            Main.getPlugin().getLogger().info("[item debug] " + message);
        }
    }
}

