/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTItem;

public class ItemMoveDropCancelListener
implements Listener {
    public ItemMoveDropCancelListener() {
        FileConfiguration inventory = Main.getConfigurationManager().getInventoryConfiguration();
        if (inventory.getBoolean("cancel-item-drop", false)) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
                public void onDrop(PlayerDropItemEvent event) {
                    if (!event.getPlayer().hasPermission("ssx.drop") && ItemMoveDropCancelListener.this.isCancelledWorld(event.getPlayer().getWorld()) && ItemMoveDropCancelListener.this.isSsxItem(event.getItemDrop().getItemStack())) {
                        event.setCancelled(true);
                        event.getItemDrop().remove();
                    }
                }
            }, (Plugin)Main.getPlugin());
        }
        if (inventory.getBoolean("cancel-item-move", false)) {
            Bukkit.getPluginManager().registerEvents(new Listener(){

                @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
                public void onItemMove(InventoryClickEvent event) {
                    event.setCancelled(event.getClickedInventory() != null && !event.getWhoClicked().hasPermission("ssx.move") && ItemMoveDropCancelListener.this.isCancelledWorld(event.getWhoClicked().getWorld()) && (ItemMoveDropCancelListener.this.isSsxItem(event.getCursor()) || ItemMoveDropCancelListener.this.isSsxItem(event.getCurrentItem()) || event.getClick() == ClickType.NUMBER_KEY && ItemMoveDropCancelListener.this.isSsxItem(event.getWhoClicked().getInventory().getItem(event.getHotbarButton()))));
                }

                @EventHandler(ignoreCancelled=true, priority=EventPriority.LOW)
                public void onItemMove(InventoryDragEvent event) {
                    event.setCancelled(!event.getWhoClicked().hasPermission("ssx.move") && ItemMoveDropCancelListener.this.isCancelledWorld(event.getWhoClicked().getWorld()) && ItemMoveDropCancelListener.this.isSsxItem(event.getCursor()));
                }
            }, (Plugin)Main.getPlugin());
        }
    }

    private boolean isCancelledWorld(World world) {
        List onlyIn = Main.getConfigurationManager().getInventoryConfiguration().getStringList("only-in-worlds");
        List exceptions = Main.getConfigurationManager().getInventoryConfiguration().getStringList("world-exceptions");
        return (onlyIn.isEmpty() || onlyIn.contains(world.getName())) && !exceptions.contains(world.getName());
    }

    private boolean isSsxItem(ItemStack item) {
        if (!Main.getConfigurationManager().getInventoryConfiguration().getBoolean("ssx-items-only", false)) {
            return true;
        }
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        NBTItem nbt = new NBTItem(item);
        return nbt.hasKey("SSXItem");
    }
}

