/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.derkades.serverselectorx.ActionsOnJoinListener;
import xyz.derkades.serverselectorx.BetaMessageJoinListener;
import xyz.derkades.serverselectorx.Commands;
import xyz.derkades.serverselectorx.HDBHandler;
import xyz.derkades.serverselectorx.ItemClickListener;
import xyz.derkades.serverselectorx.ItemGiveListener;
import xyz.derkades.serverselectorx.ItemMoveDropCancelListener;
import xyz.derkades.serverselectorx.ServerSelectorXCommand;
import xyz.derkades.serverselectorx.ServerSelectorXCommandCompleter;
import xyz.derkades.serverselectorx.Stats;
import xyz.derkades.serverselectorx.WebServer;
import xyz.derkades.serverselectorx.configuration.ConfigSync;
import xyz.derkades.serverselectorx.configuration.ConfigurationManager;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.NbtItemBuilder;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.PlaceholderUtil;
import xyz.derkades.serverselectorx.lib.gson.Gson;
import xyz.derkades.serverselectorx.lib.gson.GsonBuilder;
import xyz.derkades.serverselectorx.lib.gson.JsonObject;
import xyz.derkades.serverselectorx.lib.gson.JsonParser;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.lib.kyori.adventure.platform.bukkit.BukkitAudiences;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.Component;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.MiniMessage;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTItem;
import xyz.derkades.serverselectorx.lib.nbtapi.utils.MinecraftVersion;
import xyz.derkades.serverselectorx.placeholders.PapiExpansionRegistrar;
import xyz.derkades.serverselectorx.placeholders.Server;

public class Main
extends JavaPlugin {
    static boolean LAG_DEBUG;
    static boolean ITEM_DEBUG;
    private static ConfigurationManager configurationManager;
    private static ConfigSync configSync;
    private static Main plugin;
    private static BukkitAudiences adventure;
    public static WebServer server;
    public static final Gson GSON;
    private static final Map<UUID, String> HEAD_TEXTURE_CACHE;

    @NotNull
    public static Main getPlugin() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        MinecraftVersion.replaceLogger(this.getLogger());
        configurationManager = new ConfigurationManager();
        try {
            configurationManager.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getCommand("serverselectorx").setExecutor((CommandExecutor)new ServerSelectorXCommand());
        this.getCommand("serverselectorx").setTabCompleter((TabCompleter)new ServerSelectorXCommandCompleter());
        Commands.registerCustomCommands();
        adventure = BukkitAudiences.create((Plugin)this);
        server = new WebServer();
        server.start();
        configSync = new ConfigSync();
        new Stats();
        new ItemMoveDropCancelListener();
        Bukkit.getPluginManager().registerEvents((Listener)new ItemClickListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemGiveListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BetaMessageJoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ActionsOnJoinListener(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            PapiExpansionRegistrar.register();
        }
    }

    public void onDisable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
        if (server != null) {
            server.stop();
        }
    }

    public static ConfigurationManager getConfigurationManager() {
        return configurationManager;
    }

    static ConfigSync getConfigSync() {
        return configSync;
    }

    public static BukkitAudiences adventure() {
        return adventure;
    }

    public static NbtItemBuilder getItemBuilderFromItemSection(Player player, ConfigurationSection section) {
        String materialString = section.getString("material");
        NbtItemBuilder builder = Main.getItemBuilderFromMaterialString(player, materialString);
        boolean useMiniMessage = section.getBoolean("minimessage", false);
        if (section.contains("title")) {
            String title = section.getString("title");
            title = title.replace("{player}", player.getName());
            title = PlaceholderUtil.parsePapiPlaceholders(player, title);
            if (useMiniMessage) {
                Object c = MiniMessage.get().deserialize(title);
                title = LegacyComponentSerializer.legacySection().serialize((Component)c);
                builder.name(title);
            } else {
                title = "&r&f" + title;
                builder.coloredName(title);
            }
        } else {
            builder.name(" ");
        }
        if (section.contains("lore")) {
            ArrayList<String> lore = new ArrayList<String>(section.getStringList("lore"));
            for (int i = 0; i < lore.size(); ++i) {
                String line = (String)lore.get(i);
                PlaceholderUtil.Placeholder playerPlaceholder = new PlaceholderUtil.Placeholder("{player}", player.getName());
                line = PlaceholderUtil.parsePapiPlaceholders(player, line, playerPlaceholder);
                if (useMiniMessage) {
                    Object c = MiniMessage.get().deserialize(line);
                    line = LegacyComponentSerializer.legacySection().serialize((Component)c);
                } else {
                    line = "&r&f" + line;
                }
                lore.set(i, line);
            }
            if (useMiniMessage) {
                builder.lore(lore);
            } else {
                builder.coloredLore(lore);
            }
        }
        boolean hideFlagsDefault = false;
        if (section.getBoolean("enchanted")) {
            builder.unsafeEnchant(Enchantment.DURABILITY, 1);
            hideFlagsDefault = true;
        }
        if (section.getBoolean("hide-flags", hideFlagsDefault)) {
            builder.hideFlags(63);
        }
        if (section.isInt("amount")) {
            builder.amount(section.getInt("amount"));
        }
        if (section.isInt("durability")) {
            player.sendMessage("'durability' option is not supported in the legacy version");
        }
        if (section.isInt("data")) {
            int data = section.getInt("data");
            builder.damage(data);
        }
        if (section.isConfigurationSection("nbt")) {
            NBTItem nbt = new NBTItem(builder.create());
            ConfigurationSection nbtSection = section.getConfigurationSection("nbt");
            for (String key : nbtSection.getKeys(false)) {
                if (nbtSection.isBoolean(key)) {
                    nbt.setBoolean(key, nbtSection.getBoolean(key));
                    continue;
                }
                if (nbtSection.isString(key)) {
                    nbt.setString(key, nbtSection.getString(key));
                    continue;
                }
                if (nbtSection.isInt(key)) {
                    nbt.setInteger(key, nbtSection.getInt(key));
                    continue;
                }
                player.sendMessage("Unsupported NBT option '" + key + "'");
            }
            return new NbtItemBuilder(nbt.getItem());
        }
        return builder;
    }

    public static NbtItemBuilder getItemBuilderFromMaterialString(Player player, String materialString) {
        NbtItemBuilder builder;
        block14: {
            if (materialString == null) {
                player.sendMessage("Material is null, either specify a material or remove the material option completely");
                return new NbtItemBuilder(Material.COBBLESTONE);
            }
            if (materialString.startsWith("head:")) {
                String owner = materialString.split(":")[1];
                if (owner.equals("auto")) {
                    String texture;
                    builder = Main.getConfigurationManager().getMiscConfiguration().getBoolean("mojang-api-head-auto", false) ? ((texture = Main.getHeadTexture(UUID.fromString(owner))) != null ? ((NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3)).skullTexture(texture) : (NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3)) : (NbtItemBuilder)((NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3)).skullOwner(player.getName());
                } else {
                    try {
                        String texture = Main.getHeadTexture(UUID.fromString(owner));
                        if (texture != null) {
                            builder = ((NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3)).skullTexture(texture);
                            break block14;
                        }
                        builder = (NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3);
                    }
                    catch (IllegalArgumentException e) {
                        builder = ((NbtItemBuilder)new NbtItemBuilder(Material.SKULL_ITEM).damage(3)).skullTexture(owner);
                    }
                }
            } else if (materialString.startsWith("hdb")) {
                String id = materialString.substring(4);
                builder = HDBHandler.getBuilder(id);
            } else {
                String[] materialsToTry = materialString.split("\\|");
                Material material = null;
                for (String materialString2 : materialsToTry) {
                    try {
                        material = Material.valueOf((String)materialString2);
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                }
                if (material == null) {
                    player.sendMessage("Invalid item name '" + materialString + "'");
                    player.sendMessage("https://github.com/ServerSelectorX/ServerSelectorX/wiki/Item-names");
                    return new NbtItemBuilder(Material.COBBLESTONE);
                }
                builder = new NbtItemBuilder(material);
            }
        }
        return builder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getHeadTexture(UUID uuid) {
        if (HEAD_TEXTURE_CACHE.containsKey(uuid)) {
            return HEAD_TEXTURE_CACHE.get(uuid);
        }
        try {
            Main.getPlugin().getLogger().info("Getting texture value for " + uuid + " from Mojang API");
            HttpURLConnection connection = (HttpURLConnection)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString()).openConnection();
            try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                JsonObject jsonResponse = (JsonObject)JsonParser.parseReader(reader);
                String texture = jsonResponse.get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                HEAD_TEXTURE_CACHE.put(uuid, texture);
                Main.getPlugin().getLogger().info("Got " + texture);
                String string = texture;
                return string;
            }
        }
        catch (IOException | ClassCastException | IllegalArgumentException | IllegalStateException | IndexOutOfBoundsException | NullPointerException e) {
            Main.getPlugin().getLogger().warning("Failed to get base64 texture value for " + uuid + ". Is the UUID valid? Error details: " + e.getClass().getSimpleName() + " " + e.getMessage());
            return null;
        }
    }

    static {
        MinecraftVersion.disableUpdateCheck();
        LAG_DEBUG = false;
        ITEM_DEBUG = false;
        GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Server.class), Server.SERIALIZER).create();
        HEAD_TEXTURE_CACHE = new HashMap<UUID, String>();
    }
}

