/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.actions.Action;
import xyz.derkades.serverselectorx.lib.derkutils.Cooldown;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.placeholders.Server;

public class ServerSelectorX {
    public static void registerAction(@NotNull Action action) {
        Action.ACTIONS.add(action);
    }

    public static boolean runAction(@NotNull Player player, @NotNull String actionString) {
        return Action.runAction(player, actionString);
    }

    public static boolean runActions(@NotNull Player player, @NotNull List<String> actionStrings) {
        return Action.runActions(player, actionStrings);
    }

    @NotNull
    public static Server getServer(@NotNull String name) {
        return Server.getServer(name);
    }

    @NotNull
    public static Collection<Server> getServers() {
        return Collections.unmodifiableCollection(Server.getServers().values());
    }

    @NotNull
    public static Set<Server> getOnlineServers() {
        return Collections.unmodifiableSet(ServerSelectorX.getServers().stream().filter(Server::isOnline).collect(Collectors.toSet()));
    }

    public static int getGlobalPlayerCount() {
        return ServerSelectorX.getServers().stream().filter(Server::isOnline).mapToInt(Server::getOnlinePlayers).sum();
    }

    public static void teleportPlayerToServer(@NotNull Player player, @NotNull String server) {
        if (Cooldown.getCooldown("servertp" + player.getName() + server) > 0L) {
            return;
        }
        Cooldown.addCooldown("servertp" + player.getName() + server, 1000L);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(baos);){
            dos.writeUTF("Connect");
            dos.writeUTF(server);
            player.sendPluginMessage((Plugin)Main.getPlugin(), "BungeeCord", baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

