/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.bstats.bukkit.Metrics;
import xyz.derkades.serverselectorx.lib.bstats.charts.AdvancedPie;
import xyz.derkades.serverselectorx.lib.bstats.charts.SimplePie;

public class Stats
extends Metrics {
    public Stats() {
        super(Main.getPlugin(), 1061);
        this.addCustomChart(new SimplePie("placeholderapi", () -> {
            if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
                return "yes";
            }
            return "no";
        }));
        this.addCustomChart(new SimplePie("number_of_selectors", () -> Main.getConfigurationManager().listMenuConfigurations().size() + ""));
        this.addCustomChart(new AdvancedPie("selector_item", () -> {
            HashMap map = new HashMap();
            for (String itemName : Main.getConfigurationManager().listItemConfigurations()) {
                FileConfiguration item = Main.getConfigurationManager().getItemConfiguration(itemName);
                Material material = Material.getMaterial((String)item.getString("item.material"));
                if (material == null) continue;
                if (map.containsKey(material.toString())) {
                    map.put(material.toString(), map.get(material.toString() + 1));
                    continue;
                }
                map.put(material.toString(), 1);
            }
            return map;
        }));
        this.addCustomChart(new SimplePie("ping_api", () -> "Premium"));
        this.addCustomChart(new SimplePie("updater", () -> "Unavailable"));
        this.addCustomChart(new SimplePie("player_count_mode", () -> Main.getPlugin().getConfig().getString("item-count-mode", "absolute").toLowerCase()));
        this.addCustomChart(new SimplePie("item_drop", () -> {
            if (Main.getPlugin().getConfig().getBoolean("cancel-item-drop", false)) {
                return "Cancel";
            }
            return "Allow";
        }));
        this.addCustomChart(new SimplePie("item_move", () -> {
            if (Main.getPlugin().getConfig().getBoolean("cancel-item-move", false)) {
                return "Cancel";
            }
            return "Allow";
        }));
        this.addCustomChart(new AdvancedPie("menu_item_slot", () -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String itemName : Main.getConfigurationManager().listItemConfigurations()) {
                FileConfiguration item = Main.getConfigurationManager().getItemConfiguration(itemName);
                if (!item.getBoolean("give.join")) {
                    if (map.containsKey("Disabled")) {
                        map.put("Disabled", (Integer)map.get("Disabled") + 1);
                        continue;
                    }
                    map.put("Disabled", 1);
                    continue;
                }
                int slot = item.getInt("give.inv-slot", 0);
                if (slot < 0) {
                    if (map.containsKey("Auto")) {
                        map.put("Auto", (Integer)map.get("Auto") + 1);
                        continue;
                    }
                    map.put("Auto", 1);
                    continue;
                }
                if (map.containsKey(slot + "")) {
                    map.put(slot + "", (Integer)map.get(slot + "") + 1);
                    continue;
                }
                map.put(slot + "", 1);
            }
            return map;
        }));
        this.addCustomChart(new AdvancedPie("rows", () -> {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String menuName : Main.getConfigurationManager().listMenuConfigurations()) {
                FileConfiguration menu = Main.getConfigurationManager().getMenuConfiguration(menuName);
                int rows = menu.getInt("rows", 1);
                if (map.containsKey(rows + "")) {
                    map.put(rows + "", (Integer)map.get(rows + "") + 1);
                    continue;
                }
                map.put(rows + "", 1);
            }
            return map;
        }));
    }
}

