/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.http.GetFile;
import xyz.derkades.serverselectorx.http.ListFiles;
import xyz.derkades.serverselectorx.http.Players;
import xyz.derkades.serverselectorx.http.Root;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.HttpHandler;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.HttpServer;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.NetworkListener;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.ServerConfiguration;

public class WebServer {
    private HttpServer server;

    public void start() {
        this.server = new HttpServer();
        FileConfiguration api = Main.getConfigurationManager().getApiConfiguration();
        this.server.addListener(new NetworkListener("Listener", api.getString("host", "127.0.0.1"), api.getInt("port")));
        ServerConfiguration config = this.server.getServerConfiguration();
        config.addHttpHandler((HttpHandler)new GetFile(), "/getfile");
        config.addHttpHandler((HttpHandler)new ListFiles(), "/listfiles");
        config.addHttpHandler(new Root());
        config.addHttpHandler((HttpHandler)new Players(), "/players");
        try {
            this.server.start();
        }
        catch (IOException e) {
            Main.getPlugin().getLogger().severe("An error occured while starting webserver: " + e.getMessage());
        }
    }

    public void stop() {
        try {
            Main.getPlugin().getLogger().info("Stopping embedded webserver...");
            this.server.shutdown().get(5000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Main.getPlugin().getLogger().severe("An error occured while stopping webserver: " + e.getMessage());
        }
    }
}

