/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;
import xyz.derkades.serverselectorx.actions.AddEffectAction;
import xyz.derkades.serverselectorx.actions.AdvMessageAction;
import xyz.derkades.serverselectorx.actions.CloseAction;
import xyz.derkades.serverselectorx.actions.ConsoleCommandAction;
import xyz.derkades.serverselectorx.actions.DelayAction;
import xyz.derkades.serverselectorx.actions.FirstAvailableServerAction;
import xyz.derkades.serverselectorx.actions.MessageAction;
import xyz.derkades.serverselectorx.actions.OpenMenuAction;
import xyz.derkades.serverselectorx.actions.PlayerCommandAction;
import xyz.derkades.serverselectorx.actions.RandomServerAction;
import xyz.derkades.serverselectorx.actions.RoundRobinServerAction;
import xyz.derkades.serverselectorx.actions.ServerAction;
import xyz.derkades.serverselectorx.actions.ServerGroupAction;
import xyz.derkades.serverselectorx.actions.SoundAction;
import xyz.derkades.serverselectorx.actions.TeleportAction;
import xyz.derkades.serverselectorx.actions.ToggleEffectAction;
import xyz.derkades.serverselectorx.actions.ToggleHideOthersAction;
import xyz.derkades.serverselectorx.actions.UrlAction;

public abstract class Action {
    private static final Action[] DEFAULT_ACTIONS = new Action[]{new AdvMessageAction(), new AddEffectAction(), new CloseAction(), new ConsoleCommandAction(), new DelayAction(), new MessageAction(), new FirstAvailableServerAction(), new OpenMenuAction(), new PlayerCommandAction(), new RandomServerAction(), new RoundRobinServerAction(), new ServerAction(), new ServerGroupAction(), new SoundAction(), new TeleportAction(), new ToggleEffectAction(), new ToggleHideOthersAction(), new UrlAction()};
    public static final List<Action> ACTIONS = new ArrayList<Action>();
    private final String name;
    private final boolean requiresValue;

    public Action(String name, boolean requiresValue) {
        this.name = name;
        this.requiresValue = requiresValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public abstract boolean apply(Player var1, String var2);

    public static boolean runAction(Player player, String actionString) {
        String actionName;
        boolean hasValue;
        if (actionString.contains(":")) {
            hasValue = true;
            actionName = actionString.split(":")[0];
        } else {
            hasValue = false;
            actionName = actionString;
        }
        for (Action action : ACTIONS) {
            if (!action.getName().equals(actionName)) continue;
            if (action.requiresValue()) {
                if (hasValue) {
                    String value = actionString.substring(actionName.length() + 1);
                    return action.apply(player, value);
                }
                player.sendMessage("Action '" + actionName + "' requires a value");
                return true;
            }
            if (!hasValue) {
                return action.apply(player, null);
            }
            player.sendMessage("Action '" + actionName + "' does not require a value");
            return true;
        }
        player.sendMessage("Invalid action: '" + actionName + "'");
        return true;
    }

    public static boolean runActions(Player player, List<String> actionStrings) {
        boolean close = false;
        for (String actionString : actionStrings) {
            if (!Action.runAction(player, actionString)) continue;
            close = true;
        }
        return close;
    }

    static {
        ACTIONS.addAll(Arrays.asList(DEFAULT_ACTIONS));
    }
}

