/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.actions;

import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import xyz.derkades.serverselectorx.actions.Action;

public class AddEffectAction
extends Action {
    public AddEffectAction() {
        super("addeffect", true);
    }

    @Override
    public boolean apply(Player player, String value) {
        int duration;
        int amplifier;
        String[] split = value.split(":");
        if (split.length < 2 || split.length > 3) {
            player.sendMessage("Invalid effect format. It should be addeffect:name:amplifier or addeffect:name:amplifier:duration");
            return true;
        }
        String effectName = split[0];
        try {
            amplifier = Integer.parseInt(split[1]);
        }
        catch (NumberFormatException e) {
            player.sendMessage("'" + split[1] + "' is not a valid number");
            return true;
        }
        if (split.length == 3) {
            try {
                duration = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException e) {
                player.sendMessage("'" + split[2] + "' is not a valid number");
                return true;
            }
        } else {
            duration = Integer.MAX_VALUE;
        }
        PotionEffectType effect = PotionEffectType.getByName((String)effectName);
        if (effect == null) {
            player.sendMessage("Invalid effect type '" + value + "'.");
            player.sendMessage("https://github.com/ServerSelectorX/ServerSelectorX/wiki/Effects");
            return true;
        }
        if (player.hasPotionEffect(effect)) {
            player.removePotionEffect(effect);
        }
        if (Bukkit.getVersion().contains("1.7")) {
            player.addPotionEffect(new PotionEffect(effect, duration, amplifier, true));
        } else {
            player.addPotionEffect(new PotionEffect(effect, duration, amplifier, true, true));
        }
        return false;
    }
}

