/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.http;

import com.google.common.base.Preconditions;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.grizzly.http.Method;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.HttpHandler;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Request;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Response;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.HttpStatus;
import xyz.derkades.serverselectorx.lib.gson.stream.JsonWriter;

public class ListFiles
extends HttpHandler {
    private static final int DIR_LIST_FILE_LIMIT = 1000;

    @Override
    public void service(Request request, Response response) throws Exception {
        Preconditions.checkArgument((request.getMethod() == Method.GET ? 1 : 0) != 0, (Object)"Must use GET method");
        request.getParameters().setEncoding(StandardCharsets.UTF_8);
        FileConfiguration api = Main.getConfigurationManager().getApiConfiguration();
        if (!api.getBoolean("files-api")) {
            response.getWriter().write("Files API disabled\n");
            response.setStatus(HttpStatus.FORBIDDEN_403);
            return;
        }
        Logger logger = Main.getPlugin().getLogger();
        String dirName = request.getParameter("dir");
        File dir = new File(Main.getPlugin().getDataFolder(), dirName);
        if (!dir.isDirectory()) {
            logger.warning("Received bad request from " + request.getRemoteAddr());
            logger.warning("Requested to list files in " + dirName + ", but it is not a directory.");
            response.setStatus(HttpStatus.BAD_REQUEST_400);
            return;
        }
        ArrayDeque<File> directories = new ArrayDeque<File>();
        directories.push(dir);
        response.setContentType("text/json");
        JsonWriter writer = Main.GSON.newJsonWriter(response.getWriter());
        writer.beginArray();
        int i = 0;
        while (!directories.isEmpty()) {
            if (++i > 1000) {
                logger.warning("Listing too many files! Received a request to list files in directory " + dir + ", but there are a lot of files in this directory, apparently. To avoid crashing the server from running out of memory, SSX will only list " + 1000 + " in a directory.");
                logger.warning("If you're seeing this you're either doing something dumb with paths in the config sync configuration file, or your SSX API is not secured properly and someone else is having a look at the files on your server.");
                break;
            }
            File file = (File)directories.pop();
            if (file.isFile()) {
                writer.value(file.getPath());
            }
            if (!file.isDirectory()) continue;
            for (File f : file.listFiles()) {
                directories.push(f);
            }
        }
        writer.endArray();
    }
}

