/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.derkutils.bukkit.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;

public class ReflectionUtil {
    private static final Map<String, Class<?>> classCache = new HashMap();
    private static final String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];

    public static Class<?> getMinecraftClass(String pathToClass) throws ClassNotFoundException {
        Class<?> cached = classCache.get(pathToClass);
        if (cached == null) {
            String className = String.format(pathToClass, version);
            className = className.replace(".v1_17_R1", "");
            cached = Class.forName(className);
            classCache.put(pathToClass, cached);
        }
        return cached;
    }

    public static int getPing(Player player) {
        try {
            Object entityPlayer = ReflectionUtil.getMinecraftClass("org.bukkit.craftbukkit.%s.entity.CraftPlayer").getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object ping = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.EntityPlayer").getField("ping").get(entityPlayer);
            return (Integer)ping;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return -1;
        }
    }

    @Deprecated
    public static ItemStack addCanPlaceOn(ItemStack item, String ... minecraftItemNames) {
        try {
            Class<?> craftItemStackClass = ReflectionUtil.getMinecraftClass("org.bukkit.craftbukkit.%s.inventory.CraftItemStack");
            Object nmsItemStack = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class).invoke(null, item);
            Class<?> nbtClass = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.NBTTagCompound");
            Object nbt = nmsItemStack.getClass().getMethod("getTag", new Class[0]).invoke(null, new Object[0]);
            if (nbt == null) {
                nbt = nbtClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Object nbtList = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.NBTTagList").getConstructor(new Class[0]).newInstance(new Object[0]);
            for (String minecraftItemName : minecraftItemNames) {
                if (!minecraftItemName.contains("minecraft")) {
                    minecraftItemName = "minecraft:" + minecraftItemName;
                }
                Object nbtString = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.NBTTagString").getConstructor(String.class).newInstance(minecraftItemName);
                nbtList.getClass().getMethod("add", nbtString.getClass()).invoke(nbtList, nbtString);
            }
            nbtClass.getMethod("set", String.class, nbtList.getClass()).invoke(nbt, "CanPlaceOn", nbtList);
            nmsItemStack.getClass().getMethod("setTag", nbtClass).invoke(nmsItemStack, nbt);
            Object bukkitItemStack = craftItemStackClass.getMethod("asBukkitCopy", nmsItemStack.getClass()).invoke(null, nmsItemStack);
            return (ItemStack)bukkitItemStack;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static ItemStack addCanDestroy(ItemStack item, String ... minecraftItemNames) {
        try {
            Class<?> craftItemStackClass = ReflectionUtil.getMinecraftClass("org.bukkit.craftbukkit.%s.inventory.CraftItemStack");
            Object nmsItemStack = craftItemStackClass.getMethod("asNMSCopy", ItemStack.class).invoke(null, item);
            Class<?> nbtClass = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.NBTTagCompound");
            Object nbt = nmsItemStack.getClass().getMethod("getTag", new Class[0]).invoke(null, new Object[0]);
            if (nbt == null) {
                nbt = nbtClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Object nbtList = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.NBTTagList").getConstructor(new Class[0]).newInstance(new Object[0]);
            for (String minecraftItemName : minecraftItemNames) {
                if (!minecraftItemName.contains("minecraft")) {
                    minecraftItemName = "minecraft:" + minecraftItemName;
                }
                Object nbtString = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.NBTTagString").getConstructor(String.class).newInstance(minecraftItemName);
                nbtList.getClass().getMethod("add", nbtString.getClass()).invoke(nbtList, nbtString);
            }
            nbtClass.getMethod("set", String.class, nbtList.getClass()).invoke(nbt, "CanDestroy", nbtList);
            nmsItemStack.getClass().getMethod("setTag", nbtClass).invoke(nmsItemStack, nbt);
            Object bukkitItemStack = craftItemStackClass.getMethod("asBukkitCopy", nmsItemStack.getClass()).invoke(null, nmsItemStack);
            return (ItemStack)bukkitItemStack;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    public static CommandMap getCommandMap() {
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            return (CommandMap)field.get(Bukkit.getServer());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerCommand(@NotNull String name, @NotNull Command command) {
        ReflectionUtil.getCommandMap().register(name, command);
    }

    @NotNull
    public static Map<String, Command> getKnownCommands() {
        try {
            CommandMap map = ReflectionUtil.getCommandMap();
            return (Map)map.getClass().getMethod("getKnownCommands", new Class[0]).invoke((Object)map, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unregisterCommand(Command command) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(command.getName());
        names.addAll(command.getAliases());
        command.unregister(ReflectionUtil.getCommandMap());
        names.forEach(ReflectionUtil.getKnownCommands()::remove);
    }

    @Deprecated
    public static List<String> materialToMinecraftName(Material ... materials) {
        ArrayList<String> itemNames = new ArrayList<String>();
        try {
            Class<?> magicNumbersClass = ReflectionUtil.getMinecraftClass("org.bukkit.craftbukkit.%s.util.CraftMagicNumbers");
            Class<?> nmsItemClass = ReflectionUtil.getMinecraftClass("net.minecraft.server.%s.Item");
            Method getItemMethod = magicNumbersClass.getMethod("getItem", Material.class);
            Method getNameMethod = nmsItemClass.getMethod("getName", new Class[0]);
            for (Material material : materials) {
                Object nmsItem = getItemMethod.invoke(null, material);
                String minecraftName = (String)getNameMethod.invoke(nmsItem, new Object[0]);
                itemNames.add(minecraftName);
            }
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return itemNames;
    }
}

