/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly;

import xyz.derkades.serverselectorx.lib.grizzly.Cacheable;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.Result;
import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;
import xyz.derkades.serverselectorx.lib.grizzly.utils.Holder;

public class ReadResult<K, L>
implements Result,
Cacheable {
    private static final ThreadCache.CachedTypeIndex<ReadResult> CACHE_IDX = ThreadCache.obtainIndex(ReadResult.class, 4);
    private boolean isRecycled = false;
    private Connection<L> connection;
    private K message;
    private Holder<L> srcAddressHolder;
    private int readSize;

    public static <K, L> ReadResult<K, L> create(Connection<L> connection) {
        ReadResult<K, L> readResult = ReadResult.takeFromCache();
        if (readResult != null) {
            readResult.connection = connection;
            readResult.isRecycled = false;
            return readResult;
        }
        return new ReadResult<K, L>(connection);
    }

    public static <K, L> ReadResult<K, L> create(Connection<L> connection, K message, L srcAddress, int readSize) {
        ReadResult<K, L> readResult = ReadResult.takeFromCache();
        if (readResult != null) {
            readResult.connection = connection;
            readResult.message = message;
            readResult.srcAddressHolder = Holder.staticHolder(srcAddress);
            readResult.readSize = readSize;
            readResult.isRecycled = false;
            return readResult;
        }
        return new ReadResult<K, L>(connection, message, srcAddress, readSize);
    }

    private static <K, L> ReadResult<K, L> takeFromCache() {
        return ThreadCache.takeFromCache(CACHE_IDX);
    }

    protected ReadResult() {
    }

    protected ReadResult(Connection<L> connection) {
        this(connection, null, null, 0);
    }

    protected ReadResult(Connection<L> connection, K message, L srcAddress, int readSize) {
        this.connection = connection;
        this.message = message;
        this.srcAddressHolder = Holder.staticHolder(srcAddress);
        this.readSize = readSize;
    }

    @Override
    public final Connection<L> getConnection() {
        this.checkRecycled();
        return this.connection;
    }

    public final K getMessage() {
        this.checkRecycled();
        return this.message;
    }

    public final void setMessage(K message) {
        this.checkRecycled();
        this.message = message;
    }

    public final L getSrcAddress() {
        this.checkRecycled();
        return this.srcAddressHolder != null ? (L)this.srcAddressHolder.get() : null;
    }

    public final Holder<L> getSrcAddressHolder() {
        this.checkRecycled();
        return this.srcAddressHolder;
    }

    public final void setSrcAddress(L srcAddress) {
        this.checkRecycled();
        this.srcAddressHolder = Holder.staticHolder(srcAddress);
    }

    public final void setSrcAddressHolder(Holder<L> srcAddressHolder) {
        this.checkRecycled();
        this.srcAddressHolder = srcAddressHolder;
    }

    public final int getReadSize() {
        this.checkRecycled();
        return this.readSize;
    }

    public final void setReadSize(int readSize) {
        this.checkRecycled();
        this.readSize = readSize;
    }

    protected void set(Connection<L> connection, K message, L srcAddress, int readSize) {
        this.connection = connection;
        this.message = message;
        this.srcAddressHolder = Holder.staticHolder(srcAddress);
        this.readSize = readSize;
    }

    protected void reset() {
        this.connection = null;
        this.message = null;
        this.srcAddressHolder = null;
        this.readSize = 0;
    }

    private void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            throw new IllegalStateException("ReadResult has been recycled!");
        }
    }

    @Override
    public void recycle() {
        this.reset();
        this.isRecycled = true;
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public Object copy() {
        return ReadResult.create(this.getConnection(), this.getMessage(), this.getSrcAddress(), this.getReadSize());
    }
}

