/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import xyz.derkades.serverselectorx.lib.grizzly.threadpool.DefaultWorkerThread;

public final class ThreadCache {
    private static final ObjectCacheElement[] INITIAL_OBJECT_ARRAY = new ObjectCacheElement[16];
    private static final Map<String, CachedTypeIndex> typeIndexMap = new HashMap<String, CachedTypeIndex>();
    private static int indexCounter;
    private static final ThreadLocal<ObjectCache> genericCacheAttr;

    public static synchronized <E> CachedTypeIndex<E> obtainIndex(Class<E> clazz, int size) {
        return ThreadCache.obtainIndex(clazz.getName(), clazz, size);
    }

    public static synchronized <E> CachedTypeIndex<E> obtainIndex(String name, Class<E> clazz, int size) {
        CachedTypeIndex<E> typeIndex = typeIndexMap.get(name);
        if (typeIndex == null) {
            typeIndex = new CachedTypeIndex<E>(indexCounter++, name, clazz, size);
            typeIndexMap.put(name, typeIndex);
        }
        return typeIndex;
    }

    public static <E> boolean putToCache(CachedTypeIndex<E> index, E o) {
        return ThreadCache.putToCache(Thread.currentThread(), index, o);
    }

    public static <E> boolean putToCache(Thread currentThread, CachedTypeIndex<E> index, E o) {
        if (currentThread instanceof DefaultWorkerThread) {
            return ((DefaultWorkerThread)currentThread).putToCache(index, o);
        }
        ObjectCache genericCache = genericCacheAttr.get();
        if (genericCache == null) {
            genericCache = new ObjectCache();
            genericCacheAttr.set(genericCache);
        }
        return genericCache.put(index, o);
    }

    public static <E> E getFromCache(CachedTypeIndex<E> index) {
        return ThreadCache.getFromCache(Thread.currentThread(), index);
    }

    public static <E> E getFromCache(Thread currentThread, CachedTypeIndex<E> index) {
        assert (currentThread == Thread.currentThread());
        if (currentThread instanceof DefaultWorkerThread) {
            return ((DefaultWorkerThread)currentThread).getFromCache(index);
        }
        ObjectCache genericCache = genericCacheAttr.get();
        if (genericCache != null) {
            return genericCache.get(index);
        }
        return null;
    }

    public static <E> E takeFromCache(CachedTypeIndex<E> index) {
        return ThreadCache.takeFromCache(Thread.currentThread(), index);
    }

    public static <E> E takeFromCache(Thread currentThread, CachedTypeIndex<E> index) {
        if (currentThread instanceof DefaultWorkerThread) {
            return ((DefaultWorkerThread)currentThread).takeFromCache(index);
        }
        ObjectCache genericCache = genericCacheAttr.get();
        if (genericCache != null) {
            return genericCache.take(index);
        }
        return null;
    }

    static {
        genericCacheAttr = new ThreadLocal();
    }

    public static final class CachedTypeIndex<E> {
        private final int index;
        private final Class clazz;
        private final int size;
        private final String name;

        public CachedTypeIndex(int index, String name, Class<E> clazz, int size) {
            this.index = index;
            this.name = name;
            this.clazz = clazz;
            this.size = size;
        }

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public int getSize() {
            return this.size;
        }
    }

    public static final class ObjectCacheElement {
        private final int size;
        private final Object[] cache;
        private int index;

        public ObjectCacheElement(int size) {
            this.size = size;
            this.cache = new Object[size];
        }

        public boolean put(Object o) {
            if (this.index < this.size) {
                this.cache[this.index++] = o;
                return true;
            }
            return false;
        }

        public Object get() {
            if (this.index > 0) {
                Object o = this.cache[this.index - 1];
                return o;
            }
            return null;
        }

        public Object take() {
            if (this.index > 0) {
                --this.index;
                Object o = this.cache[this.index];
                this.cache[this.index] = null;
                return o;
            }
            return null;
        }
    }

    public static final class ObjectCache {
        private ObjectCacheElement[] objectCacheElements;

        public boolean put(CachedTypeIndex index, Object o) {
            ObjectCacheElement objectCache;
            if (this.objectCacheElements != null && index.getIndex() < this.objectCacheElements.length) {
                ObjectCacheElement objectCache2 = this.objectCacheElements[index.getIndex()];
                if (objectCache2 == null) {
                    this.objectCacheElements[index.getIndex()] = objectCache2 = new ObjectCacheElement(index.size);
                }
                return objectCache2.put(o);
            }
            ObjectCacheElement[] arrayToGrow = this.objectCacheElements != null ? this.objectCacheElements : INITIAL_OBJECT_ARRAY;
            int newSize = Math.max(index.getIndex() + 1, arrayToGrow.length * 3 / 2 + 1);
            this.objectCacheElements = Arrays.copyOf(arrayToGrow, newSize);
            this.objectCacheElements[index.getIndex()] = objectCache = new ObjectCacheElement(index.getSize());
            return objectCache.put(o);
        }

        public <E> E get(CachedTypeIndex<E> index) {
            int idx;
            if (this.objectCacheElements != null && (idx = index.getIndex()) < this.objectCacheElements.length) {
                ObjectCacheElement objectCache = this.objectCacheElements[idx];
                if (objectCache == null) {
                    return null;
                }
                return (E)objectCache.get();
            }
            return null;
        }

        public <E> E take(CachedTypeIndex<E> index) {
            int idx;
            if (this.objectCacheElements != null && (idx = index.getIndex()) < this.objectCacheElements.length) {
                ObjectCacheElement objectCache = this.objectCacheElements[idx];
                if (objectCache == null) {
                    return null;
                }
                return (E)objectCache.take();
            }
            return null;
        }
    }
}

