/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.ConnectionProbe;
import xyz.derkades.serverselectorx.lib.grizzly.GracefulShutdownListener;
import xyz.derkades.serverselectorx.lib.grizzly.GrizzlyFuture;
import xyz.derkades.serverselectorx.lib.grizzly.IOEvent;
import xyz.derkades.serverselectorx.lib.grizzly.IOEventLifeCycleListener;
import xyz.derkades.serverselectorx.lib.grizzly.IOStrategy;
import xyz.derkades.serverselectorx.lib.grizzly.Processor;
import xyz.derkades.serverselectorx.lib.grizzly.ProcessorSelector;
import xyz.derkades.serverselectorx.lib.grizzly.Reader;
import xyz.derkades.serverselectorx.lib.grizzly.TransportProbe;
import xyz.derkades.serverselectorx.lib.grizzly.Writer;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeBuilder;
import xyz.derkades.serverselectorx.lib.grizzly.memory.MemoryManager;
import xyz.derkades.serverselectorx.lib.grizzly.monitoring.MonitoringAware;
import xyz.derkades.serverselectorx.lib.grizzly.monitoring.MonitoringConfig;
import xyz.derkades.serverselectorx.lib.grizzly.threadpool.ThreadPoolConfig;
import xyz.derkades.serverselectorx.lib.grizzly.threadpool.ThreadPoolProbe;
import xyz.derkades.serverselectorx.lib.grizzly.utils.StateHolder;

public interface Transport
extends MonitoringAware<TransportProbe> {
    public static final int DEFAULT_READ_BUFFER_SIZE = -1;
    public static final int DEFAULT_WRITE_BUFFER_SIZE = -1;
    public static final int DEFAULT_READ_TIMEOUT = 30;
    public static final int DEFAULT_WRITE_TIMEOUT = 30;

    public String getName();

    public void setName(String var1);

    public StateHolder<State> getState();

    public boolean isBlocking();

    public void configureBlocking(boolean var1);

    public void configureStandalone(boolean var1);

    public boolean isStandalone();

    public Processor obtainProcessor(IOEvent var1, Connection var2);

    public Processor getProcessor();

    public void setProcessor(Processor var1);

    public ProcessorSelector getProcessorSelector();

    public void setProcessorSelector(ProcessorSelector var1);

    public MemoryManager getMemoryManager();

    public void setMemoryManager(MemoryManager var1);

    public IOStrategy getIOStrategy();

    public void setIOStrategy(IOStrategy var1);

    public int getReadBufferSize();

    public void setReadBufferSize(int var1);

    public int getWriteBufferSize();

    public void setWriteBufferSize(int var1);

    public ExecutorService getWorkerThreadPool();

    public ExecutorService getKernelThreadPool();

    public void setWorkerThreadPool(ExecutorService var1);

    public void setKernelThreadPool(ExecutorService var1);

    public void setKernelThreadPoolConfig(ThreadPoolConfig var1);

    public void setWorkerThreadPoolConfig(ThreadPoolConfig var1);

    public ThreadPoolConfig getKernelThreadPoolConfig();

    public ThreadPoolConfig getWorkerThreadPoolConfig();

    public AttributeBuilder getAttributeBuilder();

    public void setAttributeBuilder(AttributeBuilder var1);

    public void start() throws IOException;

    @Deprecated
    public void stop() throws IOException;

    public GrizzlyFuture<Transport> shutdown();

    public GrizzlyFuture<Transport> shutdown(long var1, TimeUnit var3);

    public void shutdownNow() throws IOException;

    public boolean addShutdownListener(GracefulShutdownListener var1);

    public void pause();

    public void resume();

    public void fireIOEvent(IOEvent var1, Connection var2, IOEventLifeCycleListener var3);

    public boolean isStopped();

    public boolean isPaused();

    public Reader getReader(Connection var1);

    public Reader getReader(boolean var1);

    public Writer getWriter(Connection var1);

    public Writer getWriter(boolean var1);

    public MonitoringConfig<ConnectionProbe> getConnectionMonitoringConfig();

    public MonitoringConfig<ThreadPoolProbe> getThreadPoolMonitoringConfig();

    @Override
    public MonitoringConfig<TransportProbe> getMonitoringConfig();

    public void notifyTransportError(Throwable var1);

    public long getReadTimeout(TimeUnit var1);

    public void setReadTimeout(long var1, TimeUnit var3);

    public long getWriteTimeout(TimeUnit var1);

    public void setWriteTimeout(long var1, TimeUnit var3);

    public static enum State {
        STARTING,
        STARTED,
        PAUSING,
        PAUSED,
        STOPPING,
        STOPPED;

    }
}

