/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.attributes;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.Attribute;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeBuilder;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeHolder;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.DefaultAttributeBuilder;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.IndexedAttributeAccessor;
import xyz.derkades.serverselectorx.lib.grizzly.utils.NullaryFunction;

final class UnsafeAttributeHolder
implements AttributeHolder {
    final DefaultAttributeBuilder attributeBuilder;
    final IndexedAttributeAccessorImpl indexedAttributeAccessor;
    private final Holder h1 = new Holder();
    private final Holder h2 = new Holder();
    private final Holder h3 = new Holder();
    private final Holder h4 = new Holder();
    private Map<Integer, Object> valueMap;
    private boolean isSet;

    UnsafeAttributeHolder(DefaultAttributeBuilder attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        this.indexedAttributeAccessor = new IndexedAttributeAccessorImpl();
    }

    @Override
    public Object getAttribute(String name) {
        return this.getAttribute(name, null);
    }

    @Override
    public Object getAttribute(String name, NullaryFunction initializer) {
        if (!this.isSet && initializer == null) {
            return null;
        }
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            return this.indexedAttributeAccessor.getAttribute(attribute, initializer);
        }
        return initializer != null ? initializer.evaluate() : null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute == null) {
            attribute = this.attributeBuilder.createAttribute(name);
        }
        this.indexedAttributeAccessor.setAttribute(attribute, value);
    }

    @Override
    public Object removeAttribute(String name) {
        if (!this.isSet) {
            return null;
        }
        Attribute attribute = this.attributeBuilder.getAttributeByName(name);
        if (attribute != null) {
            return this.indexedAttributeAccessor.removeAttribute(attribute);
        }
        return null;
    }

    @Override
    public Set<String> getAttributeNames() {
        if (!this.isSet) {
            return null;
        }
        HashSet<String> tmpSet = new HashSet<String>(4);
        if (this.h1.isSet && this.h1.value != null) {
            tmpSet.add(this.attributeBuilder.getAttributeByIndex(this.h1.idx).name());
        }
        if (this.h2.isSet && this.h2.value != null) {
            tmpSet.add(this.attributeBuilder.getAttributeByIndex(this.h2.idx).name());
        }
        if (this.h3.isSet && this.h3.value != null) {
            tmpSet.add(this.attributeBuilder.getAttributeByIndex(this.h3.idx).name());
        }
        if (this.h4.isSet && this.h4.value != null) {
            tmpSet.add(this.attributeBuilder.getAttributeByIndex(this.h4.idx).name());
        }
        if (this.valueMap != null) {
            for (Integer idx : this.valueMap.keySet()) {
                tmpSet.add(this.attributeBuilder.getAttributeByIndex(idx).name());
            }
        }
        return tmpSet;
    }

    @Override
    public void clear() {
        if (!this.isSet) {
            return;
        }
        this.isSet = false;
        this.h1.clear();
        this.h2.clear();
        this.h3.clear();
        this.h4.clear();
        this.valueMap = null;
    }

    @Override
    public void recycle() {
        this.clear();
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public IndexedAttributeAccessor getIndexedAttributeAccessor() {
        return this.indexedAttributeAccessor;
    }

    @Override
    public void copyFrom(AttributeHolder srcAttributes) {
        if (srcAttributes == null) {
            throw new NullPointerException("srcAttributes can't be null");
        }
        if (srcAttributes instanceof UnsafeAttributeHolder) {
            UnsafeAttributeHolder srcUnsafe = (UnsafeAttributeHolder)srcAttributes;
            if (!srcUnsafe.isSet) {
                this.clear();
                return;
            }
            this.isSet = true;
            this.h1.copyFrom(srcUnsafe.h1);
            this.h2.copyFrom(srcUnsafe.h2);
            this.h3.copyFrom(srcUnsafe.h3);
            this.h4.copyFrom(srcUnsafe.h4);
            if (this.valueMap != null || srcUnsafe.valueMap != null) {
                MapperAccessor.copy(srcUnsafe, this);
            }
        } else {
            this.clear();
            Set<String> names = srcAttributes.getAttributeNames();
            for (String name : names) {
                this.setAttribute(name, srcAttributes.getAttribute(name));
            }
        }
    }

    @Override
    public void copyTo(AttributeHolder dstAttributes) {
        if (dstAttributes == null) {
            throw new NullPointerException("dstAttributes can't be null");
        }
        if (!this.isSet) {
            dstAttributes.clear();
            return;
        }
        if (dstAttributes instanceof UnsafeAttributeHolder) {
            UnsafeAttributeHolder dstUnsafe = (UnsafeAttributeHolder)dstAttributes;
            dstUnsafe.isSet = true;
            dstUnsafe.h1.copyFrom(this.h1);
            dstUnsafe.h2.copyFrom(this.h2);
            dstUnsafe.h3.copyFrom(this.h3);
            dstUnsafe.h4.copyFrom(this.h4);
            if (this.valueMap != null || dstUnsafe.valueMap != null) {
                MapperAccessor.copy(this, dstUnsafe);
            }
        } else {
            dstAttributes.clear();
            Set<String> names = this.getAttributeNames();
            for (String name : names) {
                dstAttributes.setAttribute(name, this.getAttribute(name));
            }
        }
    }

    private static final class MapperAccessor {
        private MapperAccessor() {
        }

        private static Object getValue(UnsafeAttributeHolder holder, Integer idx) {
            return holder.valueMap.get(idx);
        }

        private static Object setValue(UnsafeAttributeHolder holder, Integer idx, Object value) {
            if (value == null) {
                if (holder.valueMap != null) {
                    return holder.valueMap.remove(idx);
                }
                return null;
            }
            if (holder.valueMap == null) {
                holder.valueMap = new HashMap(4);
            }
            return holder.valueMap.put(idx, value);
        }

        private static void copy(UnsafeAttributeHolder src, UnsafeAttributeHolder dst) {
            if (src.valueMap != null) {
                if (dst.valueMap == null) {
                    dst.valueMap = new HashMap(src.valueMap.size());
                } else {
                    dst.valueMap.clear();
                }
                dst.valueMap.putAll(src.valueMap);
            } else {
                dst.valueMap = null;
            }
        }
    }

    private static final class Holder {
        int idx;
        Object value;
        boolean isSet;

        private Holder() {
        }

        Object set(int idx, Object value) {
            Object oldValue = this.value;
            this.idx = idx;
            this.value = value;
            this.isSet = true;
            return oldValue;
        }

        void clear() {
            if (this.isSet) {
                this.idx = -1;
                this.value = null;
                this.isSet = false;
            }
        }

        private boolean is(int idx) {
            return this.isSet && this.idx == idx;
        }

        private void copyFrom(Holder src) {
            this.isSet = src.isSet;
            this.idx = src.idx;
            this.value = src.value;
        }
    }

    protected final class IndexedAttributeAccessorImpl
    implements IndexedAttributeAccessor {
        protected IndexedAttributeAccessorImpl() {
        }

        @Override
        public Object getAttribute(int index) {
            return this.getAttribute(index, null);
        }

        @Override
        public Object getAttribute(int index, NullaryFunction initializer) {
            if (!UnsafeAttributeHolder.this.isSet && initializer == null) {
                return null;
            }
            return this.getAttribute(UnsafeAttributeHolder.this.attributeBuilder.getAttributeByIndex(index), initializer);
        }

        @Override
        public void setAttribute(int index, Object value) {
            this.setAttribute(UnsafeAttributeHolder.this.attributeBuilder.getAttributeByIndex(index), value);
        }

        @Override
        public Object removeAttribute(int index) {
            return this.removeAttribute(UnsafeAttributeHolder.this.attributeBuilder.getAttributeByIndex(index));
        }

        private Object getAttribute(Attribute attribute, NullaryFunction initializer) {
            Object value;
            int idx = attribute.index();
            Holder h = this.holderByIdx(idx);
            if (h != null) {
                if (h.value == null && initializer != null) {
                    h.value = initializer.evaluate();
                }
                return h.value;
            }
            Object object = value = UnsafeAttributeHolder.this.valueMap != null ? MapperAccessor.getValue(UnsafeAttributeHolder.this, idx) : null;
            if (value == null && initializer != null) {
                value = initializer.evaluate();
                this.setAttribute(attribute, value);
            }
            return value;
        }

        private Object setAttribute(Attribute attribute, Object value) {
            if (!UnsafeAttributeHolder.this.isSet) {
                if (value != null) {
                    UnsafeAttributeHolder.this.isSet = true;
                    UnsafeAttributeHolder.this.h1.set(attribute.index(), value);
                }
                return null;
            }
            UnsafeAttributeHolder.this.isSet = true;
            int idx = attribute.index();
            Holder h = this.holderByIdx(idx);
            if (h != null) {
                return h.set(idx, value);
            }
            if (UnsafeAttributeHolder.this.valueMap != null && UnsafeAttributeHolder.this.valueMap.get(idx) != value) {
                return MapperAccessor.setValue(UnsafeAttributeHolder.this, idx, value);
            }
            if (value == null) {
                return null;
            }
            h = this.emptyHolder();
            if (h != null) {
                h.set(idx, value);
                return null;
            }
            h = this.nullHolder();
            if (h != null) {
                h.set(idx, value);
                return null;
            }
            return MapperAccessor.setValue(UnsafeAttributeHolder.this, idx, value);
        }

        private Object removeAttribute(Attribute attribute) {
            return this.setAttribute(attribute, null);
        }

        private Holder holderByIdx(int idx) {
            if (UnsafeAttributeHolder.this.h1.is(idx)) {
                return UnsafeAttributeHolder.this.h1;
            }
            if (UnsafeAttributeHolder.this.h2.is(idx)) {
                return UnsafeAttributeHolder.this.h2;
            }
            if (UnsafeAttributeHolder.this.h3.is(idx)) {
                return UnsafeAttributeHolder.this.h3;
            }
            if (UnsafeAttributeHolder.this.h4.is(idx)) {
                return UnsafeAttributeHolder.this.h4;
            }
            return null;
        }

        private Holder emptyHolder() {
            if (!((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h1.isSet) {
                return UnsafeAttributeHolder.this.h1;
            }
            if (!((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h2.isSet) {
                return UnsafeAttributeHolder.this.h2;
            }
            if (!((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h3.isSet) {
                return UnsafeAttributeHolder.this.h3;
            }
            if (!((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h4.isSet) {
                return UnsafeAttributeHolder.this.h4;
            }
            return null;
        }

        private Holder nullHolder() {
            if (((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h1.value == null) {
                return UnsafeAttributeHolder.this.h1;
            }
            if (((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h2.value == null) {
                return UnsafeAttributeHolder.this.h2;
            }
            if (((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h3.value == null) {
                return UnsafeAttributeHolder.this.h3;
            }
            if (((UnsafeAttributeHolder)UnsafeAttributeHolder.this).h4.value == null) {
                return UnsafeAttributeHolder.this.h4;
            }
            return null;
        }
    }
}

