/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.nio.transport;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.CloseReason;
import xyz.derkades.serverselectorx.lib.grizzly.Closeable;
import xyz.derkades.serverselectorx.lib.grizzly.CompletionHandler;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.EmptyCompletionHandler;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.GrizzlyFuture;
import xyz.derkades.serverselectorx.lib.grizzly.IOEvent;
import xyz.derkades.serverselectorx.lib.grizzly.impl.FutureImpl;
import xyz.derkades.serverselectorx.lib.grizzly.impl.SafeFutureImpl;
import xyz.derkades.serverselectorx.lib.grizzly.nio.RegisterChannelResult;
import xyz.derkades.serverselectorx.lib.grizzly.nio.SelectionKeyHandler;
import xyz.derkades.serverselectorx.lib.grizzly.nio.transport.TCPNIOConnection;
import xyz.derkades.serverselectorx.lib.grizzly.nio.transport.TCPNIOTransport;
import xyz.derkades.serverselectorx.lib.grizzly.utils.CompletionHandlerAdapter;
import xyz.derkades.serverselectorx.lib.grizzly.utils.Exceptions;
import xyz.derkades.serverselectorx.lib.grizzly.utils.Holder;
import xyz.derkades.serverselectorx.lib.grizzly.utils.NullaryFunction;

public final class TCPNIOServerConnection
extends TCPNIOConnection {
    private static boolean DISABLE_INTERRUPT_CLEAR = Boolean.valueOf(System.getProperty(TCPNIOServerConnection.class.getName() + "_DISABLE_INTERRUPT_CLEAR", "false"));
    private static final Logger LOGGER = Grizzly.logger(TCPNIOServerConnection.class);
    private FutureImpl<Connection> acceptListener;
    private final RegisterAcceptedChannelCompletionHandler defaultCompletionHandler;
    private final Object acceptSync = new Object();

    public TCPNIOServerConnection(TCPNIOTransport transport, ServerSocketChannel serverSocketChannel) {
        super(transport, serverSocketChannel);
        this.defaultCompletionHandler = new RegisterAcceptedChannelCompletionHandler();
    }

    public void listen() throws IOException {
        TCPNIOTransport.RegisterChannelCompletionHandler registerCompletionHandler = ((TCPNIOTransport)this.transport).selectorRegistrationHandler;
        SafeFutureImpl future = SafeFutureImpl.create();
        this.transport.getNIOChannelDistributor().registerServiceChannelAsync(this.channel, 16, this, new CompletionHandlerAdapter(future, registerCompletionHandler));
        try {
            future.get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw Exceptions.makeIOException(e.getCause());
        }
        catch (Exception e) {
            throw Exceptions.makeIOException(e);
        }
        this.notifyReady();
        TCPNIOServerConnection.notifyProbesBind(this);
    }

    @Override
    public boolean isBlocking() {
        return this.transport.isBlocking();
    }

    @Override
    public boolean isStandalone() {
        return this.transport.isStandalone();
    }

    public GrizzlyFuture<Connection> accept() throws IOException {
        if (!this.isStandalone()) {
            throw new IllegalStateException("Accept could be used in standalone mode only");
        }
        GrizzlyFuture<Connection> future = this.acceptAsync();
        if (this.isBlocking()) {
            try {
                future.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GrizzlyFuture<Connection> acceptAsync() throws IOException {
        if (!this.isOpen()) {
            throw new IOException("Connection is closed");
        }
        Object object = this.acceptSync;
        synchronized (object) {
            SafeFutureImpl<Connection> future = SafeFutureImpl.create();
            SocketChannel acceptedChannel = this.doAccept();
            if (acceptedChannel != null) {
                this.configureAcceptedChannel(acceptedChannel);
                TCPNIOConnection clientConnection = this.createClientConnection(acceptedChannel);
                this.registerAcceptedChannel(clientConnection, new RegisterAcceptedChannelCompletionHandler(future), 0);
            } else {
                this.acceptListener = future;
                this.enableIOEvent(IOEvent.SERVER_ACCEPT);
            }
            return future;
        }
    }

    private SocketChannel doAccept() throws IOException {
        if (!DISABLE_INTERRUPT_CLEAR && Thread.currentThread().isInterrupted()) {
            Thread.interrupted();
        }
        return ((ServerSocketChannel)this.getChannel()).accept();
    }

    private void configureAcceptedChannel(SocketChannel acceptedChannel) throws IOException {
        TCPNIOTransport tcpNIOTransport = (TCPNIOTransport)this.transport;
        tcpNIOTransport.getChannelConfigurator().preConfigure(this.transport, acceptedChannel);
        tcpNIOTransport.getChannelConfigurator().postConfigure(this.transport, acceptedChannel);
    }

    private TCPNIOConnection createClientConnection(SocketChannel acceptedChannel) {
        TCPNIOTransport tcpNIOTransport = (TCPNIOTransport)this.transport;
        TCPNIOConnection connection = tcpNIOTransport.obtainNIOConnection(acceptedChannel);
        if (this.processor != null) {
            connection.setProcessor(this.processor);
        }
        if (this.processorSelector != null) {
            connection.setProcessorSelector(this.processorSelector);
        }
        connection.resetProperties();
        return connection;
    }

    private void registerAcceptedChannel(TCPNIOConnection acceptedConnection, CompletionHandler<RegisterChannelResult> completionHandler, int initialSelectionKeyInterest) throws IOException {
        TCPNIOTransport tcpNIOTransport = (TCPNIOTransport)this.transport;
        tcpNIOTransport.getNIOChannelDistributor().registerChannelAsync(acceptedConnection.getChannel(), initialSelectionKeyInterest, acceptedConnection, completionHandler);
    }

    @Override
    public void preClose() {
        if (this.acceptListener != null) {
            this.acceptListener.failure(new IOException("Connection is closed"));
        }
        this.transport.unbind(this);
        super.preClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAccept() throws IOException {
        if (!this.isStandalone()) {
            SocketChannel acceptedChannel = this.doAccept();
            if (acceptedChannel == null) {
                return;
            }
            this.configureAcceptedChannel(acceptedChannel);
            TCPNIOConnection acceptedConnection = this.createClientConnection(acceptedChannel);
            TCPNIOServerConnection.notifyProbesAccept(this, acceptedConnection);
            this.registerAcceptedChannel(acceptedConnection, this.defaultCompletionHandler, 1);
        } else {
            Object object = this.acceptSync;
            synchronized (object) {
                if (this.acceptListener == null) {
                    this.disableIOEvent(IOEvent.SERVER_ACCEPT);
                    return;
                }
                SocketChannel acceptedChannel = this.doAccept();
                if (acceptedChannel == null) {
                    return;
                }
                this.configureAcceptedChannel(acceptedChannel);
                TCPNIOConnection acceptedConnection = this.createClientConnection(acceptedChannel);
                TCPNIOServerConnection.notifyProbesAccept(this, acceptedConnection);
                this.registerAcceptedChannel(acceptedConnection, new RegisterAcceptedChannelCompletionHandler(this.acceptListener), 0);
                this.acceptListener = null;
            }
        }
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        throw new IllegalStateException("Use TCPNIOTransport.setReadBufferSize()");
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        throw new IllegalStateException("Use TCPNIOTransport.setWriteBufferSize()");
    }

    @Override
    public int getReadBufferSize() {
        return this.transport.getReadBufferSize();
    }

    @Override
    public int getWriteBufferSize() {
        return this.transport.getWriteBufferSize();
    }

    @Override
    protected void closeGracefully0(CompletionHandler<Closeable> completionHandler, CloseReason closeReason) {
        this.terminate0(completionHandler, closeReason);
    }

    @Override
    protected void resetProperties() {
        this.localSocketAddressHolder = Holder.lazyHolder(new NullaryFunction<SocketAddress>(){

            @Override
            public SocketAddress evaluate() {
                return ((ServerSocketChannel)TCPNIOServerConnection.this.channel).socket().getLocalSocketAddress();
            }
        });
        this.peerSocketAddressHolder = Holder.staticHolder(null);
    }

    protected final class RegisterAcceptedChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private final FutureImpl<Connection> listener;

        public RegisterAcceptedChannelCompletionHandler() {
            this(null);
        }

        public RegisterAcceptedChannelCompletionHandler(FutureImpl<Connection> listener) {
            this.listener = listener;
        }

        @Override
        public void completed(RegisterChannelResult result) {
            try {
                TCPNIOTransport nioTransport = (TCPNIOTransport)TCPNIOServerConnection.this.transport;
                nioTransport.selectorRegistrationHandler.completed(result);
                SelectionKeyHandler selectionKeyHandler = nioTransport.getSelectionKeyHandler();
                SelectionKey acceptedConnectionKey = result.getSelectionKey();
                TCPNIOConnection connection = (TCPNIOConnection)selectionKeyHandler.getConnectionForKey(acceptedConnectionKey);
                if (this.listener != null) {
                    this.listener.result(connection);
                }
                if (connection.notifyReady()) {
                    TCPNIOServerConnection.this.transport.fireIOEvent(IOEvent.ACCEPTED, connection, null);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception happened, when trying to accept the connection", e);
            }
        }
    }
}

