/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.strategies;

import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.IOEvent;
import xyz.derkades.serverselectorx.lib.grizzly.IOEventLifeCycleListener;
import xyz.derkades.serverselectorx.lib.grizzly.strategies.AbstractIOStrategy;

public final class WorkerThreadIOStrategy
extends AbstractIOStrategy {
    private static final WorkerThreadIOStrategy INSTANCE = new WorkerThreadIOStrategy();
    private static final Logger logger = Grizzly.logger(WorkerThreadIOStrategy.class);

    private WorkerThreadIOStrategy() {
    }

    public static WorkerThreadIOStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean executeIoEvent(Connection connection, IOEvent ioEvent, boolean isIoEventEnabled) throws IOException {
        IOEventLifeCycleListener listener;
        boolean isReadOrWriteEvent = WorkerThreadIOStrategy.isReadWrite(ioEvent);
        if (isReadOrWriteEvent) {
            if (isIoEventEnabled) {
                connection.disableIOEvent(ioEvent);
            }
            listener = ENABLE_INTEREST_LIFECYCLE_LISTENER;
        } else {
            listener = null;
        }
        Executor threadPool = this.getThreadPoolFor(connection, ioEvent);
        if (threadPool != null) {
            threadPool.execute(new WorkerThreadRunnable(connection, ioEvent, listener));
        } else {
            WorkerThreadIOStrategy.run0(connection, ioEvent, listener);
        }
        return true;
    }

    private static void run0(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
        WorkerThreadIOStrategy.fireIOEvent(connection, ioEvent, lifeCycleListener, logger);
    }

    private static final class WorkerThreadRunnable
    implements Runnable {
        final Connection connection;
        final IOEvent ioEvent;
        final IOEventLifeCycleListener lifeCycleListener;

        private WorkerThreadRunnable(Connection connection, IOEvent ioEvent, IOEventLifeCycleListener lifeCycleListener) {
            this.connection = connection;
            this.ioEvent = ioEvent;
            this.lifeCycleListener = lifeCycleListener;
        }

        @Override
        public void run() {
            WorkerThreadIOStrategy.run0(this.connection, this.ioEvent, this.lifeCycleListener);
        }
    }
}

