/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.gson.internal.bind;

import java.io.IOException;
import xyz.derkades.serverselectorx.lib.gson.Gson;
import xyz.derkades.serverselectorx.lib.gson.JsonSyntaxException;
import xyz.derkades.serverselectorx.lib.gson.ToNumberPolicy;
import xyz.derkades.serverselectorx.lib.gson.ToNumberStrategy;
import xyz.derkades.serverselectorx.lib.gson.TypeAdapter;
import xyz.derkades.serverselectorx.lib.gson.TypeAdapterFactory;
import xyz.derkades.serverselectorx.lib.gson.reflect.TypeToken;
import xyz.derkades.serverselectorx.lib.gson.stream.JsonReader;
import xyz.derkades.serverselectorx.lib.gson.stream.JsonToken;
import xyz.derkades.serverselectorx.lib.gson.stream.JsonWriter;

public final class NumberTypeAdapter
extends TypeAdapter<Number> {
    private static final TypeAdapterFactory LAZILY_PARSED_NUMBER_FACTORY = NumberTypeAdapter.newFactory(ToNumberPolicy.LAZILY_PARSED_NUMBER);
    private final ToNumberStrategy toNumberStrategy;

    private NumberTypeAdapter(ToNumberStrategy toNumberStrategy) {
        this.toNumberStrategy = toNumberStrategy;
    }

    private static TypeAdapterFactory newFactory(ToNumberStrategy toNumberStrategy) {
        NumberTypeAdapter adapter = new NumberTypeAdapter(toNumberStrategy);
        return new TypeAdapterFactory(){

            @Override
            public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
                return type.getRawType() == Number.class ? NumberTypeAdapter.this : null;
            }
        };
    }

    public static TypeAdapterFactory getFactory(ToNumberStrategy toNumberStrategy) {
        if (toNumberStrategy == ToNumberPolicy.LAZILY_PARSED_NUMBER) {
            return LAZILY_PARSED_NUMBER_FACTORY;
        }
        return NumberTypeAdapter.newFactory(toNumberStrategy);
    }

    @Override
    public Number read(JsonReader in) throws IOException {
        JsonToken jsonToken = in.peek();
        switch (jsonToken) {
            case NULL: {
                in.nextNull();
                return null;
            }
            case NUMBER: 
            case STRING: {
                return this.toNumberStrategy.readNumber(in);
            }
        }
        throw new JsonSyntaxException("Expecting number, got: " + (Object)((Object)jsonToken));
    }

    @Override
    public void write(JsonWriter out, Number value) throws IOException {
        out.value(value);
    }
}

