/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.kyori.adventure.nbt;

import java.util.ArrayList;
import java.util.List;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.Nullable;
import xyz.derkades.serverselectorx.lib.kyori.adventure.nbt.BinaryTag;
import xyz.derkades.serverselectorx.lib.kyori.adventure.nbt.BinaryTagType;
import xyz.derkades.serverselectorx.lib.kyori.adventure.nbt.BinaryTagTypes;
import xyz.derkades.serverselectorx.lib.kyori.adventure.nbt.ListBinaryTag;
import xyz.derkades.serverselectorx.lib.kyori.adventure.nbt.ListBinaryTagImpl;

final class ListTagBuilder<T extends BinaryTag>
implements ListBinaryTag.Builder<T> {
    @Nullable
    private List<BinaryTag> tags;
    private BinaryTagType<? extends BinaryTag> elementType;

    ListTagBuilder() {
        this(BinaryTagTypes.END);
    }

    ListTagBuilder(BinaryTagType<? extends BinaryTag> type) {
        this.elementType = type;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(BinaryTag tag) {
        ListBinaryTagImpl.noAddEnd(tag);
        if (this.elementType == BinaryTagTypes.END) {
            this.elementType = tag.type();
        }
        ListBinaryTagImpl.mustBeSameType(tag, this.elementType);
        if (this.tags == null) {
            this.tags = new ArrayList<BinaryTag>();
        }
        this.tags.add(tag);
        return this;
    }

    @Override
    public @NotNull ListBinaryTag.Builder<T> add(Iterable<? extends T> tagsToAdd) {
        for (BinaryTag tag : tagsToAdd) {
            this.add(tag);
        }
        return this;
    }

    @Override
    @NotNull
    public ListBinaryTag build() {
        if (this.tags == null) {
            return ListBinaryTag.empty();
        }
        return new ListBinaryTagImpl(this.elementType, new ArrayList<BinaryTag>(this.tags));
    }
}

