/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage;

import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.Component;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.MiniMessageImpl;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.Template;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.parser.Token;

public class Context {
    private final boolean strict;
    private List<Token> tokens;
    private final String ogMessage;
    private String replacedMessage;
    private final MiniMessageImpl miniMessage;
    private final @NonNull Template @Nullable [] templates;

    Context(boolean strict, List<Token> tokens, String ogMessage, String replacedMessage, MiniMessageImpl miniMessage, @NonNull Template @Nullable [] templates) {
        this.strict = strict;
        this.tokens = tokens;
        this.ogMessage = ogMessage;
        this.replacedMessage = replacedMessage;
        this.miniMessage = miniMessage;
        this.templates = templates;
    }

    public static Context of(boolean strict, String input, MiniMessageImpl miniMessage) {
        return new Context(strict, null, input, null, miniMessage, null);
    }

    public static Context of(boolean strict, String input, MiniMessageImpl miniMessage, @NonNull Template @Nullable [] templates) {
        return new Context(strict, null, input, null, miniMessage, templates);
    }

    public void tokens(List<Token> tokens) {
        this.tokens = tokens;
    }

    public void replacedMessage(String replacedMessage) {
        this.replacedMessage = replacedMessage;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public List<Token> tokens() {
        return this.tokens;
    }

    public String ogMessage() {
        return this.ogMessage;
    }

    public String replacedMessage() {
        return this.replacedMessage;
    }

    public MiniMessageImpl miniMessage() {
        return this.miniMessage;
    }

    public Component parse(String message) {
        if (this.templates != null) {
            return this.miniMessage.parse(message, this.templates);
        }
        return this.miniMessage.parse(message);
    }
}

