/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.derkades.serverselectorx.lib.kyori.adventure.key.Key;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.Component;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.KeybindComponent;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.TextComponent;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.TranslatableComponent;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.event.ClickEvent;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.event.HoverEvent;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.format.NamedTextColor;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.format.Style;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.format.TextColor;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.format.TextDecoration;

final class MiniMessageSerializer {
    private MiniMessageSerializer() {
    }

    static @NonNull String serialize(@NonNull Component component) {
        List<ComponentNode> nodes = MiniMessageSerializer.traverseNode(new ComponentNode(component));
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodes.size(); ++i) {
            Style previous = i - 1 >= 0 ? nodes.get(i - 1).style() : null;
            Style next = i + 1 < nodes.size() ? nodes.get(i + 1).style() : null;
            ComponentNode node = nodes.get(i);
            sb.append(MiniMessageSerializer.serializeNode(node, previous, next));
        }
        return sb.toString();
    }

    private static List<ComponentNode> traverseNode(@NonNull ComponentNode root) {
        LinkedList<ComponentNode> nodes = new LinkedList<ComponentNode>();
        nodes.add(root);
        if (!root.component().children().isEmpty()) {
            for (Component child : root.component().children()) {
                nodes.addAll(MiniMessageSerializer.traverseNode(new ComponentNode(child, root.style())));
            }
        }
        return nodes;
    }

    private static String serializeNode(@NonNull ComponentNode node, @Nullable Style previous, @Nullable Style next) {
        Key font;
        String insert;
        ClickEvent click;
        HoverEvent<?> hov;
        StringBuilder sb = new StringBuilder();
        Style style = node.style();
        if (style.color() != null && (previous == null || previous.color() != style.color())) {
            sb.append(MiniMessageSerializer.startColor(Objects.requireNonNull(style.color())));
        }
        if (style.hasDecoration(TextDecoration.BOLD) && (previous == null || !previous.hasDecoration(TextDecoration.BOLD))) {
            sb.append(MiniMessageSerializer.startTag("bold"));
        }
        if (style.hasDecoration(TextDecoration.ITALIC) && (previous == null || !previous.hasDecoration(TextDecoration.ITALIC))) {
            sb.append(MiniMessageSerializer.startTag("italic"));
        }
        if (style.hasDecoration(TextDecoration.OBFUSCATED) && (previous == null || !previous.hasDecoration(TextDecoration.OBFUSCATED))) {
            sb.append(MiniMessageSerializer.startTag("obfuscated"));
        }
        if (style.hasDecoration(TextDecoration.STRIKETHROUGH) && (previous == null || !previous.hasDecoration(TextDecoration.STRIKETHROUGH))) {
            sb.append(MiniMessageSerializer.startTag("strikethrough"));
        }
        if (style.hasDecoration(TextDecoration.UNDERLINED) && (previous == null || !previous.hasDecoration(TextDecoration.UNDERLINED))) {
            sb.append(MiniMessageSerializer.startTag("underlined"));
        }
        if ((hov = style.hoverEvent()) != null && (previous == null || MiniMessageSerializer.areDifferent(hov, previous.hoverEvent()))) {
            MiniMessageSerializer.serializeHoverEvent(sb, hov);
        }
        if ((click = style.clickEvent()) != null && (previous == null || MiniMessageSerializer.areDifferent(click, previous.clickEvent()))) {
            sb.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "click", ClickEvent.Action.NAMES.key(click.action()), click.value())));
        }
        if (!((insert = style.insertion()) == null || previous != null && insert.equals(previous.insertion()))) {
            sb.append(MiniMessageSerializer.startTag("insert:" + insert));
        }
        if (!((font = style.font()) == null || previous != null && font.equals(previous.font()))) {
            sb.append(MiniMessageSerializer.startTag("font:" + font.asString()));
        }
        if (node.component() instanceof TextComponent) {
            sb.append(((TextComponent)node.component()).content());
        } else {
            MiniMessageSerializer.handleDifferentComponent(node.component(), sb);
        }
        if (next != null && style.color() != null && next.color() != style.color()) {
            sb.append(MiniMessageSerializer.endColor(Objects.requireNonNull(style.color())));
        }
        if (next != null) {
            if (style.hasDecoration(TextDecoration.BOLD) && !next.hasDecoration(TextDecoration.BOLD)) {
                sb.append(MiniMessageSerializer.endTag("bold"));
            }
            if (style.hasDecoration(TextDecoration.ITALIC) && !next.hasDecoration(TextDecoration.ITALIC)) {
                sb.append(MiniMessageSerializer.endTag("italic"));
            }
            if (style.hasDecoration(TextDecoration.OBFUSCATED) && !next.hasDecoration(TextDecoration.OBFUSCATED)) {
                sb.append(MiniMessageSerializer.endTag("obfuscated"));
            }
            if (style.hasDecoration(TextDecoration.STRIKETHROUGH) && !next.hasDecoration(TextDecoration.STRIKETHROUGH)) {
                sb.append(MiniMessageSerializer.endTag("strikethrough"));
            }
            if (style.hasDecoration(TextDecoration.UNDERLINED) && !next.hasDecoration(TextDecoration.UNDERLINED)) {
                sb.append(MiniMessageSerializer.endTag("underlined"));
            }
        }
        if (next != null && style.hoverEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(style.hoverEvent()), next.hoverEvent())) {
            sb.append(MiniMessageSerializer.endTag("hover"));
        }
        if (next != null && style.clickEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(style.clickEvent()), next.clickEvent())) {
            sb.append(MiniMessageSerializer.endTag("click"));
        }
        if (next != null && style.insertion() != null && !Objects.equals(style.insertion(), next.insertion())) {
            sb.append(MiniMessageSerializer.endTag("insert"));
        }
        if (next != null && style.font() != null && !Objects.equals(style.font(), next.font())) {
            sb.append(MiniMessageSerializer.endTag("font"));
        }
        return sb.toString();
    }

    private static void serializeHoverEvent(@NonNull StringBuilder sb, @NonNull HoverEvent<?> hov) {
        if (hov.action() == HoverEvent.Action.SHOW_TEXT) {
            sb.append(MiniMessageSerializer.startTag("hover:" + HoverEvent.Action.NAMES.key(hov.action()) + ":" + "\"" + MiniMessageSerializer.serialize((Component)hov.value()).replace("\"", "\\\"") + "\""));
        } else if (hov.action() == HoverEvent.Action.SHOW_ITEM) {
            HoverEvent.ShowItem showItem = (HoverEvent.ShowItem)hov.value();
            String nbt = showItem.nbt() != null ? ":\"" + showItem.nbt().string().replace("\"", "\\\"") + "\"" : "";
            sb.append(MiniMessageSerializer.startTag("hover:" + HoverEvent.Action.NAMES.key(hov.action()) + ":" + "'" + showItem.item().asString() + "'" + ":" + showItem.count() + nbt));
        } else if (hov.action() == HoverEvent.Action.SHOW_ENTITY) {
            HoverEvent.ShowEntity showEntity = (HoverEvent.ShowEntity)hov.value();
            String displayName = showEntity.name() != null ? ":\"" + MiniMessageSerializer.serialize(showEntity.name()).replace("\"", "\\\"") + "\"" : "";
            sb.append(MiniMessageSerializer.startTag("hover:" + HoverEvent.Action.NAMES.key(hov.action()) + ":" + "'" + showEntity.type().asString() + "'" + ":" + showEntity.id().toString() + displayName));
        } else {
            throw new RuntimeException("Don't know how to serialize '" + hov + "'!");
        }
    }

    private static boolean areDifferent(@NonNull ClickEvent c1, @Nullable ClickEvent c2) {
        if (c2 == null) {
            return true;
        }
        return !c1.equals(c2) && (!c1.action().equals((Object)c2.action()) || !c1.value().equals(c2.value()));
    }

    private static boolean areDifferent(@NonNull HoverEvent<?> h1, @Nullable HoverEvent<?> h2) {
        if (h2 == null) {
            return true;
        }
        return !h1.equals(h2) && !h1.action().equals(h2.action());
    }

    private static @NonNull String startColor(@NonNull TextColor color) {
        if (color instanceof NamedTextColor) {
            return MiniMessageSerializer.startTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)color)));
        }
        return MiniMessageSerializer.startTag("color:" + color.asHexString());
    }

    private static @NonNull String endColor(@NonNull TextColor color) {
        if (color instanceof NamedTextColor) {
            return MiniMessageSerializer.endTag(Objects.requireNonNull(NamedTextColor.NAMES.key((NamedTextColor)color)));
        }
        return MiniMessageSerializer.endTag("color:" + color.asHexString());
    }

    private static @NonNull String startTag(@NonNull String content) {
        return "<" + content + ">";
    }

    private static @NonNull String endTag(@NonNull String content) {
        return "</" + content + ">";
    }

    private static void handleDifferentComponent(@NonNull Component component, @NonNull StringBuilder sb) {
        if (component instanceof KeybindComponent) {
            sb.append(MiniMessageSerializer.startTag("key:" + ((KeybindComponent)component).keybind()));
        } else if (component instanceof TranslatableComponent) {
            StringBuilder args = new StringBuilder();
            for (Component arg : ((TranslatableComponent)component).args()) {
                args.append(":").append("\"").append(MiniMessageSerializer.serialize(arg).replace("\"", "\\\"")).append("\"");
            }
            sb.append(MiniMessageSerializer.startTag("lang:" + ((TranslatableComponent)component).key() + args));
        }
    }

    private static class ComponentNode {
        private final Component component;
        private final Style style;

        ComponentNode(@NonNull Component component) {
            this(component, null);
        }

        ComponentNode(@NonNull Component component, @Nullable Style parent) {
            this.component = component;
            this.style = parent == null ? component.style() : component.style().merge(parent, Style.Merge.Strategy.IF_ABSENT_ON_TARGET);
        }

        public Component component() {
            return this.component;
        }

        public Style style() {
            return this.style;
        }
    }
}

