/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.actions.Action;
import xyz.derkades.serverselectorx.lib.derkutils.Cooldown;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.Colors;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.reflection.ReflectionUtil;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;

public class Commands {
    static void registerCustomCommands() {
        CommandMap commandMap = ReflectionUtil.getCommandMap();
        for (final String commandName : Main.getConfigurationManager().listCommandConfigurations()) {
            final FileConfiguration config = Main.getConfigurationManager().getCommandConfiguration(commandName);
            String description = config.getString("description", "Opens menu");
            String usage = config.getString("usage", "/<command>");
            List aliases = config.getStringList("aliases");
            final List actions = config.getStringList("actions");
            if (commandMap.getCommand(commandName) != null) {
                Main.getPlugin().getLogger().warning("Skipped registering command /" + commandName + ", it already exists.");
                continue;
            }
            commandMap.register("ssx-custom", new Command(commandName, description, usage, aliases){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] args) {
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        FileConfiguration configMisc = Main.getConfigurationManager().getMiscConfiguration();
                        if (config.isInt("cooldown")) {
                            long timeLeft = Cooldown.getCooldown("ssxcommand" + commandName);
                            if (timeLeft > 0L) {
                                player.sendMessage(Colors.parseColors(String.format(configMisc.getString("cooldown-message"), (double)timeLeft / 1000.0)));
                                return true;
                            }
                            Cooldown.addCooldown("ssxcommand" + commandName, config.getInt("cooldown"));
                        }
                        if (config.getBoolean("permission", false) && !player.hasPermission("ssx.command." + commandName)) {
                            if (configMisc.isString("no-permission")) {
                                player.sendMessage(Colors.parseColors(configMisc.getString("no-permission")));
                            }
                            return true;
                        }
                        Action.runActions(player, actions);
                    }
                    return true;
                }
            });
        }
    }
}

