/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.ServerSelectorX;
import xyz.derkades.serverselectorx.actions.Action;
import xyz.derkades.serverselectorx.lib.derkutils.Cooldown;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.Colors;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.NbtItemBuilder;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.IconMenu;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.MenuCloseEvent;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.OptionClickEvent;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.Nullable;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTItem;
import xyz.derkades.serverselectorx.placeholders.GlobalPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Placeholder;
import xyz.derkades.serverselectorx.placeholders.PlayerPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Server;

public class Menu
extends IconMenu {
    private final FileConfiguration config;
    private boolean closed = false;

    public Menu(final Player player, final @Nullable FileConfiguration config, String configName) {
        super((Plugin)Main.getPlugin(), config == null ? "error" : Colors.parseColors(config.getString("title", "TITLE MISSING")), config == null ? 1 : config.getInt("rows", 6), player);
        this.config = config;
        if (this.config == null || this.config.getConfigurationSection("menu") == null) {
            player.sendMessage("The configuration file failed to load, probably due to a syntax error.");
            player.sendMessage("Take a look at the console for any YAML errors, or paste your config in http://www.yamllint.com/");
            player.sendMessage("Check for identation and balanced quotes. If you want to use quotation marks in strings, they must be escaped properly by putting two quotation marks (for example \"\" or '').");
            player.sendMessage("Menu name: " + configName);
            return;
        }
        try {
            if (config.contains("sound")) {
                player.playSound(player.getLocation(), Sound.valueOf((String)config.getString("sound")), 1.0f, 1.0f);
            }
        }
        catch (IllegalArgumentException e) {
            Main.getPlugin().getLogger().warning("Invalid sound name in config file '" + configName + "'");
            Main.getPlugin().getLogger().warning("https://github.com/ServerSelectorX/ServerSelectorX/wiki/Sound-names");
        }
        int updateInterval = config.getInt("update-interval", 100);
        new BukkitRunnable(){

            public void run() {
                if (Menu.this.closed || Bukkit.getPlayer((String)player.getName()) == null) {
                    this.cancel();
                    return;
                }
                long start = System.nanoTime();
                if (Main.LAG_DEBUG) {
                    Main.getPlugin().getLogger().info("Starting menu load for player " + player.getName());
                }
                Menu.this.addItems();
                if (Main.LAG_DEBUG) {
                    long diff = System.nanoTime() - start;
                    Main.getPlugin().getLogger().info(String.format("--Finished (re)loading menu in %.2f\u03bcs. (one tick is 50ms)", Float.valueOf((float)diff / 1000.0f)));
                }
                if (config.getBoolean("disable-updates", false)) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)updateInterval);
    }

    private void addItems() {
        FileConfiguration configMisc = Main.getConfigurationManager().getMiscConfiguration();
        OfflinePlayer potentiallyOffline = this.getPlayer();
        if (!(potentiallyOffline instanceof Player)) {
            Main.getPlugin().getLogger().warning("Player " + potentiallyOffline.getUniqueId() + " went offline?");
            return;
        }
        Player player = (Player)potentiallyOffline;
        block2: for (String key : this.config.getConfigurationSection("menu").getKeys(false)) {
            ConfigurationSection chosenSection;
            NbtItemBuilder builder;
            long itemStart = System.nanoTime();
            if (!this.config.isConfigurationSection("menu." + key)) {
                player.sendMessage("Invalid item " + key + ", check indentation.");
                continue;
            }
            ConfigurationSection section = this.config.getConfigurationSection("menu." + key);
            if (section.contains("permission") && !player.hasPermission(section.getString("permission"))) {
                ConfigurationSection noPermissionSection = section.getConfigurationSection("no-permission");
                if (noPermissionSection == null) {
                    player.sendMessage("Missing no-permission section for item " + key + ". Remove the permission option or add a no-permission section.");
                    return;
                }
                String materialString = noPermissionSection.getString("material");
                if (materialString == null) {
                    player.sendMessage("No permission section is missing the material option");
                    return;
                }
                if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                builder = Main.getItemBuilderFromItemSection(player, noPermissionSection);
                chosenSection = noPermissionSection;
            } else if (section.contains("connector")) {
                String serverName = section.getString("connector");
                Server server = Server.getServer(serverName);
                if (server.isOnline()) {
                    builder = null;
                    chosenSection = null;
                    if (configMisc.contains("server-name") && serverName.equalsIgnoreCase(configMisc.getString("server-name")) && section.isConfigurationSection("connected")) {
                        ConfigurationSection connectedSection = section.getConfigurationSection("connected");
                        builder = Main.getItemBuilderFromItemSection(player, connectedSection);
                        chosenSection = connectedSection;
                    } else {
                        if (section.contains("dynamic")) {
                            for (String dynamicKey : section.getConfigurationSection("dynamic").getKeys(false)) {
                                ConfigurationSection dynamicSection;
                                String mode;
                                String placeholderValueFromConnector;
                                long colons = dynamicKey.chars().filter(c -> c == 58).count();
                                if (colons != 1L) {
                                    player.sendMessage("Invalid dynamic section '" + dynamicKey + "'. Dynamic section identifiers should contain exactly one colon, this one contains " + colons + ".");
                                    return;
                                }
                                String[] split = dynamicKey.split(":");
                                String placeholderKeyInConfig = split[0];
                                String placeholderValueInConfig = split[1];
                                Placeholder placeholder = server.getPlaceholder(placeholderKeyInConfig);
                                if (placeholder == null) {
                                    Main.getPlugin().getLogger().warning("Dynamic feature contains rule with placeholder " + placeholder + " which has not been received from the server.");
                                    continue;
                                }
                                if (placeholder instanceof GlobalPlaceholder) {
                                    GlobalPlaceholder global = (GlobalPlaceholder)placeholder;
                                    placeholderValueFromConnector = global.getValue();
                                } else {
                                    PlayerPlaceholder playerPlaceholder = (PlayerPlaceholder)placeholder;
                                    placeholderValueFromConnector = playerPlaceholder.getValue((OfflinePlayer)player);
                                }
                                if (!((mode = (dynamicSection = section.getConfigurationSection("dynamic." + dynamicKey)).getString("mode", "equals")).equals("equals") && placeholderValueInConfig.equals(placeholderValueFromConnector) || mode.equals("less") && Double.parseDouble(placeholderValueInConfig) > Double.parseDouble(placeholderValueFromConnector)) && (!mode.equals("more") || !(Double.parseDouble(placeholderValueInConfig) < Double.parseDouble(placeholderValueFromConnector)))) continue;
                                String materialString = dynamicSection.getString("material");
                                if (materialString == null) {
                                    player.sendMessage("Dynamic section '" + dynamicKey + "' is missing the material option");
                                    return;
                                }
                                if (materialString.equals("NONE") || materialString.equals("AIR")) continue block2;
                                builder = Main.getItemBuilderFromItemSection(player, dynamicSection);
                                chosenSection = dynamicSection;
                                break;
                            }
                        }
                        if (builder == null) {
                            if (!section.isConfigurationSection("online")) {
                                player.sendMessage("Error for item " + key);
                                player.sendMessage("Online section does not exist");
                                return;
                            }
                            ConfigurationSection onlineSection = section.getConfigurationSection("online");
                            String materialString = onlineSection.getString("material");
                            if (materialString == null) {
                                player.sendMessage("Error for item " + key);
                                player.sendMessage("Online section does not have a material option");
                            }
                            if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                            builder = Main.getItemBuilderFromItemSection(player, onlineSection);
                            chosenSection = onlineSection;
                        }
                    }
                    HashMap<String, String> placeholders = new HashMap<String, String>();
                    for (Placeholder placeholder : server.getPlaceholders()) {
                        String value;
                        if (placeholder instanceof GlobalPlaceholder) {
                            GlobalPlaceholder global = (GlobalPlaceholder)placeholder;
                            value = global.getValue();
                        } else {
                            PlayerPlaceholder playerPlaceholder = (PlayerPlaceholder)placeholder;
                            value = playerPlaceholder.getValue((OfflinePlayer)player);
                        }
                        placeholders.put("{" + placeholder.getKey() + "}", value);
                    }
                    ((NbtItemBuilder)builder.namePlaceholders(placeholders)).lorePlaceholders(placeholders);
                    if (section.getBoolean("dynamic-item-count", false)) {
                        int amount = server.getOnlinePlayers();
                        builder.amount(amount < 1 || amount > 64 ? 1 : amount);
                    }
                } else {
                    if (!section.isConfigurationSection("offline")) {
                        player.sendMessage("Offline section does not exist");
                        return;
                    }
                    ConfigurationSection offlineSection = section.getConfigurationSection("offline");
                    String materialString = offlineSection.getString("material");
                    if (materialString == null) {
                        player.sendMessage("Error for item " + key);
                        player.sendMessage("Offline section does not have a material option");
                    }
                    if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                    builder = Main.getItemBuilderFromItemSection(player, offlineSection);
                    chosenSection = offlineSection;
                }
            } else {
                String materialString = section.getString("material");
                if (materialString == null) {
                    player.sendMessage("Error for item " + key);
                    player.sendMessage("Missing material option. Remember, this is not an advanced section, so don't use online/offline/dynamic sections in the config.");
                    player.sendMessage("If you want to use these sections, add a connector option.");
                    player.sendMessage("Read more here: https://github.com/ServerSelectorX/ServerSelectorX/wiki/Menu-items-v2");
                }
                if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                builder = Main.getItemBuilderFromItemSection(player, section);
                chosenSection = section;
            }
            ((NbtItemBuilder)((NbtItemBuilder)builder.papi(player)).placeholder("{player}", player.getName())).placeholder("{globalOnline}", "" + ServerSelectorX.getGlobalPlayerCount());
            NBTItem nbt = new NBTItem(builder.create());
            nbt.setObject("SSXActions", chosenSection.getStringList("actions"));
            nbt.setObject("SSXActionsLeft", chosenSection.getStringList("left-click-actions"));
            nbt.setObject("SSXActionsRight", chosenSection.getStringList("right-click-actions"));
            if (chosenSection.contains("cooldown")) {
                if (!chosenSection.isList("cooldown-actions")) {
                    player.sendMessage("When using the 'cooldown' option, a list of actions 'cooldown-actions' must also be specified.");
                    return;
                }
                nbt.setInteger("SSXCooldownTime", (int)(chosenSection.getDouble("cooldown") * 1000.0));
                nbt.setString("SSXCooldownId", player.getName() + this.getInventoryView().getTitle() + key);
                nbt.setObject("SSXCooldownActions", chosenSection.getStringList("cooldown-actions"));
            }
            ItemStack item = nbt.getItem();
            if (key.equals("fill") || key.equals("-1")) {
                for (int i = 0; i < this.getInventory().getSize(); ++i) {
                    if (this.hasItem(i)) continue;
                    this.addItem(i, item);
                }
            } else {
                for (String split : key.split(",")) {
                    int slot;
                    try {
                        slot = Integer.parseInt(split);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage("Invalid slot number " + split);
                        return;
                    }
                    if (slot >= this.getInventory().getSize() || slot < 0) {
                        player.sendMessage("You put an item in slot " + slot + ", which is higher than the maximum number of slots in your menu.");
                        player.sendMessage("Use numbers 0 to " + (this.getInventory().getSize() - 1) + "or increase the number of rows in the config");
                        return;
                    }
                    this.addItem(slot, item);
                }
            }
            if (!Main.LAG_DEBUG) continue;
            long current = System.nanoTime();
            Main.getPlugin().getLogger().info(String.format("  item %s took %.2f\u03bcs", key, Float.valueOf((float)(current - itemStart) / 1000.0f)));
            itemStart = current;
        }
    }

    @Override
    public boolean onOptionClick(OptionClickEvent event) {
        Player player = event.getPlayer();
        NBTItem nbt = new NBTItem(event.getItemStack());
        List actions = nbt.getObject("SSXActions", List.class);
        List leftActions = nbt.getObject("SSXActionsLeft", List.class);
        List rightActions = nbt.getObject("SSXActionsRight", List.class);
        if (nbt.hasKey("SSXCooldownTime").booleanValue()) {
            int cooldownTime = nbt.getInteger("SSXCooldownTime");
            String cooldownId = nbt.getString("SSXCooldownId");
            if (Cooldown.getCooldown(cooldownId) > 0L) {
                List cooldownActions = nbt.getObject("SSXCooldownActions", List.class);
                return Action.runActions(player, cooldownActions);
            }
            Cooldown.addCooldown(cooldownId, cooldownTime);
        }
        boolean close = Action.runActions(player, actions);
        if (event.getClickType() == ClickType.RIGHT || event.getClickType() == ClickType.SHIFT_RIGHT) {
            close = close || Action.runActions(player, rightActions);
        } else if (event.getClickType() == ClickType.LEFT || event.getClickType() == ClickType.SHIFT_LEFT) {
            close = close || Action.runActions(player, leftActions);
        }
        return close;
    }

    @Override
    public void onClose(MenuCloseEvent event) {
        String reason;
        this.closed = true;
        Cooldown.addCooldown("ssxitemglobal" + this.getPlayer().getName(), 100L);
        if (!this.config.contains("on-close")) {
            return;
        }
        switch (event.getReason()) {
            case PLAYER_CLOSED: {
                reason = "player";
                break;
            }
            case ITEM_CLICK: {
                reason = "item";
                break;
            }
            case PLAYER_QUIT: {
                reason = "quit";
                break;
            }
            default: {
                reason = null;
            }
        }
        if (reason == null) {
            return;
        }
        this.config.getMapList("on-close").forEach(map -> {
            List reasons = (List)map.get("reasons");
            if (reasons.contains(reason)) {
                List actions = (List)map.get("actions");
                if (event.getOfflinePlayer() instanceof Player) {
                    Action.runActions(event.getPlayer(), actions);
                } else {
                    Action.runActions(null, actions);
                }
            }
        });
    }
}

