/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.derkutils.bukkit;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.AbstractItemBuilder;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTCompound;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTItem;

public class NbtItemBuilder
extends AbstractItemBuilder<NbtItemBuilder> {
    public NbtItemBuilder(@NotNull Material material) {
        super(material);
    }

    public NbtItemBuilder(@NotNull ItemStack item) {
        super(item);
    }

    @Override
    @NotNull
    public NbtItemBuilder getInstance() {
        return this;
    }

    @NotNull
    public NbtItemBuilder canDestroy(String ... vanillaNamespacedNames) {
        Objects.requireNonNull(vanillaNamespacedNames, "names varargs is null");
        NBTItem nbt = new NBTItem(this.item);
        nbt.getStringList("CanDestroy").addAll((Collection<String>)List.of(vanillaNamespacedNames));
        this.item = nbt.getItem();
        return this;
    }

    @NotNull
    public NbtItemBuilder canPlaceOn(String ... vanillaNamespacedNames) {
        Objects.requireNonNull(vanillaNamespacedNames, "names varargs is null");
        NBTItem nbt = new NBTItem(this.item);
        nbt.getStringList("CanPlaceOn").addAll((Collection<String>)List.of(vanillaNamespacedNames));
        this.item = nbt.getItem();
        return this;
    }

    @NotNull
    public NbtItemBuilder skullTexture(@NotNull String texture) {
        Objects.requireNonNull(texture, "Texture string is null");
        NBTItem nbt = new NBTItem(this.item);
        NBTCompound skullOwner = nbt.addCompound("SkullOwner");
        skullOwner.setString("Id", UUID.randomUUID().toString());
        skullOwner.addCompound("Properties").getCompoundList("textures").addCompound().setString("Value", texture);
        this.item = nbt.getItem();
        return this;
    }

    @NotNull
    public NbtItemBuilder hideFlags(int hideFlags) {
        NBTItem nbt = new NBTItem(this.item);
        nbt.setInteger("HideFlags", hideFlags);
        this.item = nbt.getItem();
        return this;
    }
}

