/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.CloseReason;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.MenuCloseEvent;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.OptionClickEvent;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;

public abstract class IconMenu
implements Listener {
    @NotNull
    private String name;
    private final int size;
    @NotNull
    private final UUID uuid;
    @NotNull
    private final Inventory inventory;
    @NotNull
    private final InventoryView view;
    private boolean closeEventCalled = false;

    public IconMenu(@NotNull Plugin plugin, @NotNull String name, int rows, @NotNull Player player) {
        this(name, rows, player, t -> t.runTaskTimer(plugin, 1L, 1L), l -> Bukkit.getServer().getPluginManager().registerEvents(l, plugin));
    }

    public IconMenu(@NotNull String name, int rows, @NotNull Player player, @NotNull Consumer<BukkitRunnable> timerRegistrar, @NotNull Consumer<Listener> listenerRegistrar) {
        Objects.requireNonNull(name, "Name is null");
        Objects.requireNonNull(player, "Player is null");
        Objects.requireNonNull(listenerRegistrar, "Timer registrar is null");
        Objects.requireNonNull(listenerRegistrar, "Listener registrar is null");
        this.size = rows * 9;
        this.name = name;
        this.uuid = player.getUniqueId();
        this.inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
        this.view = player.openInventory(this.inventory);
        if (this.view == null) {
            System.err.println("IconMenu: Failed to open inventory for " + player.getName() + ". Did a plugin cancel the event?");
            return;
        }
        listenerRegistrar.accept(this);
        timerRegistrar.accept(new BukkitRunnable(){

            public void run() {
                Player player = Bukkit.getPlayer((UUID)IconMenu.this.uuid);
                if (player == null) {
                    if (!IconMenu.this.closeEventCalled) {
                        IconMenu.this.onClose(new MenuCloseEvent(Bukkit.getOfflinePlayer((UUID)IconMenu.this.uuid), CloseReason.PLAYER_QUIT));
                    }
                } else if (!player.getOpenInventory().getTopInventory().equals(IconMenu.this.inventory)) {
                    if (!IconMenu.this.closeEventCalled) {
                        IconMenu.this.onClose(new MenuCloseEvent((OfflinePlayer)player, CloseReason.PLAYER_CLOSED));
                    }
                } else {
                    return;
                }
                HandlerList.unregisterAll((Listener)IconMenu.this);
                this.cancel();
            }
        });
    }

    public abstract boolean onOptionClick(OptionClickEvent var1);

    public void onClose(MenuCloseEvent event) {
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public OfflinePlayer getPlayer() {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        return player != null ? player : Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public void close() {
        this.closeEventCalled = true;
        this.onClose(new MenuCloseEvent(this.getPlayer(), CloseReason.FORCE_CLOSE));
        this.view.close();
    }

    public void addItem(int slot, ItemStack item) {
        this.inventory.setItem(slot, item);
    }

    public boolean hasItem(int slot) {
        ItemStack item = this.inventory.getItem(slot);
        return item != null && item.getType() != Material.AIR;
    }

    public void clear() {
        this.inventory.clear();
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    public InventoryView getInventoryView() {
        return this.view;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemStack item;
        boolean close;
        if (!event.getView().getTopInventory().equals(this.inventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player clicker = (Player)event.getWhoClicked();
        if (slot >= 0 && slot < this.size && this.hasItem(slot) && (close = this.onOptionClick(new OptionClickEvent(clicker, slot, item = this.inventory.getItem(slot), event.getClick())))) {
            this.closeEventCalled = true;
            this.onClose(new MenuCloseEvent(this.getPlayer(), CloseReason.ITEM_CLICK));
            this.view.close();
        }
    }
}

