/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly;

import xyz.derkades.serverselectorx.lib.grizzly.Cacheable;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.Result;
import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;
import xyz.derkades.serverselectorx.lib.grizzly.utils.Holder;

public class WriteResult<K, L>
implements Result,
Cacheable {
    private static final ThreadCache.CachedTypeIndex<WriteResult> CACHE_IDX = ThreadCache.obtainIndex(WriteResult.class, 4);
    private boolean isRecycled = false;
    private Connection<L> connection;
    private K message;
    private Holder<L> dstAddressHolder;
    private long writtenSize;

    public static <K, L> WriteResult<K, L> create(Connection<L> connection) {
        WriteResult<K, L> writeResult = WriteResult.takeFromCache();
        if (writeResult != null) {
            writeResult.connection = connection;
            writeResult.isRecycled = false;
            return writeResult;
        }
        return new WriteResult<K, L>(connection);
    }

    public static <K, L> WriteResult<K, L> create(Connection<L> connection, K message, L dstAddress, long writeSize) {
        WriteResult<K, L> writeResult = WriteResult.takeFromCache();
        if (writeResult != null) {
            writeResult.set(connection, message, dstAddress, writeSize);
            writeResult.isRecycled = false;
            return writeResult;
        }
        return new WriteResult<K, L>(connection, message, dstAddress, writeSize);
    }

    private static <K, L> WriteResult<K, L> takeFromCache() {
        return ThreadCache.takeFromCache(CACHE_IDX);
    }

    protected WriteResult() {
    }

    private WriteResult(Connection<L> connection) {
        this(connection, null, null, 0L);
    }

    private WriteResult(Connection<L> connection, K message, L dstAddress, long writeSize) {
        this.set(connection, message, dstAddress, writeSize);
    }

    @Override
    public final Connection<L> getConnection() {
        this.checkRecycled();
        return this.connection;
    }

    public final K getMessage() {
        this.checkRecycled();
        return this.message;
    }

    public final void setMessage(K message) {
        this.checkRecycled();
        this.message = message;
    }

    public final L getDstAddress() {
        this.checkRecycled();
        return this.dstAddressHolder != null ? (L)this.dstAddressHolder.get() : null;
    }

    public final Holder<L> getDstAddressHolder() {
        this.checkRecycled();
        return this.dstAddressHolder;
    }

    public final void setDstAddress(L dstAddress) {
        this.checkRecycled();
        this.dstAddressHolder = this.createAddrHolder(dstAddress);
    }

    public final void setDstAddressHolder(Holder<L> dstAddressHolder) {
        this.checkRecycled();
        this.dstAddressHolder = dstAddressHolder;
    }

    public final long getWrittenSize() {
        this.checkRecycled();
        return this.writtenSize;
    }

    public final void setWrittenSize(long writeSize) {
        this.checkRecycled();
        this.writtenSize = writeSize;
    }

    private void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            throw new IllegalStateException("ReadResult has been recycled!");
        }
    }

    protected void set(Connection<L> connection, K message, L dstAddress, long writtenSize) {
        this.connection = connection;
        this.message = message;
        this.dstAddressHolder = this.createAddrHolder(dstAddress);
        this.writtenSize = writtenSize;
    }

    protected Holder<L> createAddrHolder(L dstAddress) {
        return Holder.staticHolder(dstAddress);
    }

    protected void reset() {
        this.connection = null;
        this.message = null;
        this.dstAddressHolder = null;
        this.writtenSize = 0L;
    }

    @Override
    public void recycle() {
        this.reset();
        this.isRecycled = true;
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public Object copy() {
        return WriteResult.create(this.getConnection(), this.getMessage(), this.getDstAddress(), this.getWrittenSize());
    }
}

