/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.attributes;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeBuilder;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.DefaultAttributeBuilder;

class AttributeBuilderInitializer {
    private static final String PROP = "xyz.derkades.serverselectorx.lib.grizzly.DEFAULT_ATTRIBUTE_BUILDER";
    private static final Logger LOGGER = Grizzly.logger(AttributeBuilderInitializer.class);

    AttributeBuilderInitializer() {
    }

    static AttributeBuilder initBuilder() {
        String className = System.getProperty(PROP);
        if (className != null) {
            try {
                Class<?> builderClass = Class.forName(className, true, AttributeBuilder.class.getClassLoader());
                return (AttributeBuilder)builderClass.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to load or create a new instance of AttributeBuilder {0}.  Cause: {1}", new Object[]{className, e.getMessage()});
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
                return new DefaultAttributeBuilder();
            }
        }
        return new DefaultAttributeBuilder();
    }
}

