/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.filterchain;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.Appendable;
import xyz.derkades.serverselectorx.lib.grizzly.Appender;
import xyz.derkades.serverselectorx.lib.grizzly.Buffer;
import xyz.derkades.serverselectorx.lib.grizzly.Closeable;
import xyz.derkades.serverselectorx.lib.grizzly.CompletionHandler;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.Context;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.IOEvent;
import xyz.derkades.serverselectorx.lib.grizzly.ProcessorExecutor;
import xyz.derkades.serverselectorx.lib.grizzly.ReadResult;
import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;
import xyz.derkades.serverselectorx.lib.grizzly.WriteResult;
import xyz.derkades.serverselectorx.lib.grizzly.asyncqueue.MessageCloner;
import xyz.derkades.serverselectorx.lib.grizzly.asyncqueue.PushBackHandler;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeHolder;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeStorage;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.FilterChain;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.FilterChainEvent;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.ForkAction;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.InternalContextImpl;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.InvokeAction;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.NextAction;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.RerunFilterAction;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.StopAction;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.SuspendAction;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.TransportFilter;
import xyz.derkades.serverselectorx.lib.grizzly.memory.Buffers;
import xyz.derkades.serverselectorx.lib.grizzly.memory.MemoryManager;
import xyz.derkades.serverselectorx.lib.grizzly.utils.Holder;

public class FilterChainContext
implements AttributeStorage {
    private static final Logger logger = Grizzly.logger(FilterChainContext.class);
    private static final ThreadCache.CachedTypeIndex<FilterChainContext> CACHE_IDX = ThreadCache.obtainIndex(FilterChainContext.class, 8);
    public static final int NO_FILTER_INDEX = Integer.MIN_VALUE;
    private static final NextAction INVOKE_ACTION = new InvokeAction();
    private static final NextAction STOP_ACTION = new StopAction();
    private static final NextAction SUSPEND_ACTION = new SuspendAction();
    private static final NextAction RERUN_FILTER_ACTION = new RerunFilterAction();
    final InternalContextImpl internalContext = new InternalContextImpl(this);
    final TransportContext transportFilterContext = new TransportContext();
    private volatile State state;
    private Operation operation = Operation.NONE;
    protected CompletionHandler<FilterChainContext> operationCompletionHandler;
    private final Runnable contextRunnable;
    private Object message;
    private Closeable closeable;
    protected FilterChainEvent event;
    private Holder<?> addressHolder;
    NextAction predefinedNextAction;
    private int filterIdx;
    private int startIdx;
    private int endIdx;
    private final StopAction cachedStopAction = new StopAction();
    private final InvokeAction cachedInvokeAction = new InvokeAction();
    private final List<CompletionListener> completionListeners = new ArrayList<CompletionListener>(2);
    private final List<CopyListener> copyListeners = new ArrayList<CopyListener>(2);

    public static FilterChainContext create(Connection connection) {
        return FilterChainContext.create(connection, connection);
    }

    public static FilterChainContext create(Connection connection, Closeable closeable) {
        FilterChainContext context = ThreadCache.takeFromCache(CACHE_IDX);
        if (context == null) {
            context = new FilterChainContext();
        }
        context.setConnection(connection);
        context.setCloseable(closeable);
        context.getTransportContext().isBlocking = connection.isBlocking();
        return context;
    }

    public FilterChainContext() {
        this.filterIdx = Integer.MIN_VALUE;
        this.contextRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (FilterChainContext.this.state == State.SUSPEND) {
                        FilterChainContext.this.state = State.RUNNING;
                    }
                    ProcessorExecutor.execute(FilterChainContext.this.internalContext);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Exception during running Processor", e);
                }
            }
        };
    }

    public Runnable suspend() {
        this.internalContext.suspend();
        this.state = State.SUSPEND;
        return this.getRunnable();
    }

    public void resume() {
        this.internalContext.resume();
        this.getRunnable().run();
    }

    public void resumeNext() {
        this.resume(this.getInvokeAction());
    }

    public void resume(NextAction nextAction) {
        this.internalContext.resume();
        try {
            if (this.state == State.SUSPEND) {
                this.state = State.RUNNING;
            }
            this.predefinedNextAction = nextAction;
            ProcessorExecutor.execute(this.internalContext);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception during running Processor", e);
        }
    }

    public void fork() {
        this.fork(null);
    }

    public void fork(NextAction nextAction) {
        try {
            this.predefinedNextAction = this.getForkAction(nextAction);
            ProcessorExecutor.execute(this.internalContext);
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception during running Processor", e);
        }
    }

    public State state() {
        return this.state;
    }

    public int nextFilterIdx() {
        return ++this.filterIdx;
    }

    public int previousFilterIdx() {
        return --this.filterIdx;
    }

    public int getFilterIdx() {
        return this.filterIdx;
    }

    public void setFilterIdx(int index) {
        this.filterIdx = index;
    }

    public int getStartIdx() {
        return this.startIdx;
    }

    public void setStartIdx(int startIdx) {
        this.startIdx = startIdx;
    }

    public int getEndIdx() {
        return this.endIdx;
    }

    public void setEndIdx(int endIdx) {
        this.endIdx = endIdx;
    }

    public FilterChain getFilterChain() {
        return (FilterChain)this.internalContext.getProcessor();
    }

    public Connection getConnection() {
        return this.internalContext.getConnection();
    }

    void setConnection(Connection connection) {
        this.internalContext.setConnection(connection);
    }

    public Closeable getCloseable() {
        return this.closeable;
    }

    void setCloseable(Closeable closeable) {
        this.closeable = closeable != null ? closeable : this.getConnection();
    }

    public <T> T getMessage() {
        return (T)this.message;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public Holder<?> getAddressHolder() {
        return this.addressHolder;
    }

    public void setAddressHolder(Holder<?> addressHolder) {
        this.addressHolder = addressHolder;
    }

    public Object getAddress() {
        return this.addressHolder != null ? this.addressHolder.get() : null;
    }

    public void setAddress(Object address) {
        this.addressHolder = Holder.staticHolder(address);
    }

    protected final Runnable getRunnable() {
        return this.contextRunnable;
    }

    public TransportContext getTransportContext() {
        return this.transportFilterContext;
    }

    public final Context getInternalContext() {
        return this.internalContext;
    }

    Operation getOperation() {
        return this.operation;
    }

    void setOperation(Operation operation) {
        this.operation = operation;
    }

    public NextAction getInvokeAction() {
        return INVOKE_ACTION;
    }

    public NextAction getInvokeAction(Object unparsedChunk) {
        if (unparsedChunk == null) {
            return INVOKE_ACTION;
        }
        this.cachedInvokeAction.setUnparsedChunk(unparsedChunk);
        return this.cachedInvokeAction;
    }

    public <E> NextAction getInvokeAction(E incompleteChunk, Appender<E> appender) {
        if (incompleteChunk == null) {
            return INVOKE_ACTION;
        }
        if (appender == null) {
            if (incompleteChunk instanceof Buffer) {
                appender = Buffers.getBufferAppender(true);
            } else if (!(incompleteChunk instanceof Appendable)) {
                throw new IllegalArgumentException("Remainder has to be either " + Buffer.class.getName() + " or " + Appendable.class.getName() + " but was " + incompleteChunk.getClass().getName());
            }
        }
        this.cachedInvokeAction.setIncompleteChunk(incompleteChunk, appender);
        return this.cachedInvokeAction;
    }

    public NextAction getStopAction() {
        return STOP_ACTION;
    }

    public NextAction getStopAction(Object incompleteChunk) {
        if (incompleteChunk instanceof Buffer) {
            return this.getStopAction((Buffer)incompleteChunk, Buffers.getBufferAppender(true));
        }
        return this.getStopAction(incompleteChunk, null);
    }

    public <E> NextAction getStopAction(E incompleteChunk, Appender<E> appender) {
        if (incompleteChunk == null) {
            return STOP_ACTION;
        }
        if (appender == null && !(incompleteChunk instanceof Appendable)) {
            throw new IllegalArgumentException("Remainder has to be either " + Buffer.class.getName() + " or " + Appendable.class.getName() + " but was " + incompleteChunk.getClass().getName());
        }
        this.cachedStopAction.setIncompleteChunk(incompleteChunk, appender);
        return this.cachedStopAction;
    }

    public NextAction getForkAction() {
        return this.getForkAction(null);
    }

    public NextAction getForkAction(NextAction nextAction) {
        FilterChainContext contextCopy = this.copy();
        contextCopy.addressHolder = this.addressHolder;
        contextCopy.predefinedNextAction = nextAction;
        return new ForkAction(contextCopy);
    }

    @Deprecated
    public NextAction getSuspendingStopAction() {
        return this.getForkAction();
    }

    public NextAction getSuspendAction() {
        return SUSPEND_ACTION;
    }

    public NextAction getRerunFilterAction() {
        return RERUN_FILTER_ACTION;
    }

    public ReadResult read() throws IOException {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.closeable = this.closeable;
        newContext.operation = Operation.READ;
        newContext.transportFilterContext.configureBlocking(true);
        newContext.startIdx = 0;
        newContext.filterIdx = 0;
        newContext.endIdx = this.filterIdx;
        this.getAttributes().copyTo(newContext.getAttributes());
        ReadResult rr = this.getFilterChain().read(newContext);
        newContext.completeAndRecycle();
        return rr;
    }

    public void write(Object message) {
        this.write(null, message, null, null, null, this.transportFilterContext.isBlocking());
    }

    public void write(Object message, boolean blocking) {
        this.write(null, message, null, null, null, blocking);
    }

    public void write(Object message, CompletionHandler<WriteResult> completionHandler) {
        this.write(null, message, completionHandler, null, null, this.transportFilterContext.isBlocking());
    }

    public void write(Object message, CompletionHandler<WriteResult> completionHandler, boolean blocking) {
        this.write(null, message, completionHandler, null, null, blocking);
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler) {
        this.write(address, message, completionHandler, null, null, this.transportFilterContext.isBlocking());
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, boolean blocking) {
        this.write(address, message, completionHandler, null, null, blocking);
    }

    @Deprecated
    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler) {
        this.write(address, message, completionHandler, pushBackHandler, this.transportFilterContext.isBlocking());
    }

    @Deprecated
    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler, boolean blocking) {
        this.write(address, message, completionHandler, pushBackHandler, null, blocking);
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, MessageCloner cloner) {
        this.write(address, message, completionHandler, null, cloner, this.transportFilterContext.isBlocking());
    }

    @Deprecated
    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler, MessageCloner cloner) {
        this.write(address, message, completionHandler, pushBackHandler, cloner, this.transportFilterContext.isBlocking());
    }

    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, MessageCloner cloner, boolean blocking) {
        this.write(address, message, completionHandler, null, cloner, blocking);
    }

    @Deprecated
    public void write(Object address, Object message, CompletionHandler<WriteResult> completionHandler, PushBackHandler pushBackHandler, MessageCloner cloner, boolean blocking) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.operation = Operation.WRITE;
        newContext.transportFilterContext.configureBlocking(blocking);
        newContext.message = message;
        newContext.addressHolder = address == null ? this.addressHolder : Holder.staticHolder(address);
        newContext.closeable = this.closeable;
        newContext.transportFilterContext.completionHandler = completionHandler;
        newContext.transportFilterContext.pushBackHandler = pushBackHandler;
        newContext.transportFilterContext.cloner = cloner;
        newContext.startIdx = this.filterIdx - 1;
        newContext.filterIdx = this.filterIdx - 1;
        newContext.endIdx = -1;
        this.getAttributes().copyTo(newContext.getAttributes());
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void flush(CompletionHandler completionHandler) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.operation = Operation.EVENT;
        newContext.closeable = this.closeable;
        newContext.event = TransportFilter.createFlushEvent(completionHandler);
        newContext.transportFilterContext.configureBlocking(this.transportFilterContext.isBlocking());
        newContext.addressHolder = this.addressHolder;
        newContext.startIdx = this.filterIdx - 1;
        newContext.filterIdx = this.filterIdx - 1;
        newContext.endIdx = -1;
        this.getAttributes().copyTo(newContext.getAttributes());
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void notifyUpstream(FilterChainEvent event) {
        this.notifyUpstream(event, null);
    }

    public void notifyUpstream(FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = event;
        newContext.closeable = this.closeable;
        newContext.addressHolder = this.addressHolder;
        newContext.startIdx = this.filterIdx + 1;
        newContext.filterIdx = this.filterIdx + 1;
        newContext.endIdx = this.endIdx;
        this.getAttributes().copyTo(newContext.getAttributes());
        newContext.operationCompletionHandler = completionHandler;
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void notifyDownstream(FilterChainEvent event) {
        this.notifyDownstream(event, null);
    }

    public void notifyDownstream(FilterChainEvent event, CompletionHandler<FilterChainContext> completionHandler) {
        FilterChainContext newContext = this.getFilterChain().obtainFilterChainContext(this.getConnection());
        newContext.setOperation(Operation.EVENT);
        newContext.event = event;
        newContext.closeable = this.closeable;
        newContext.addressHolder = this.addressHolder;
        newContext.startIdx = this.filterIdx - 1;
        newContext.filterIdx = this.filterIdx - 1;
        newContext.endIdx = -1;
        this.getAttributes().copyTo(newContext.getAttributes());
        newContext.operationCompletionHandler = completionHandler;
        ProcessorExecutor.execute(newContext.internalContext);
    }

    public void fail(Throwable error) {
        this.getFilterChain().fail(this, error);
    }

    @Override
    public AttributeHolder getAttributes() {
        return this.internalContext.getAttributes();
    }

    public final void addCompletionListener(CompletionListener listener) {
        this.completionListeners.add(listener);
    }

    public final boolean removeCompletionListener(CompletionListener listener) {
        return this.completionListeners.remove(listener);
    }

    public final void addCopyListener(CopyListener listener) {
        this.copyListeners.add(listener);
    }

    public final boolean removeCopyListener(CopyListener listener) {
        return this.copyListeners.remove(listener);
    }

    public final MemoryManager getMemoryManager() {
        return this.getConnection().getMemoryManager();
    }

    public FilterChainContext copy() {
        FilterChain p = this.getFilterChain();
        FilterChainContext newContext = p.obtainFilterChainContext(this.getConnection());
        newContext.setOperation(this.getOperation());
        newContext.setCloseable(this.getCloseable());
        this.internalContext.softCopyTo(newContext.internalContext);
        newContext.setStartIdx(this.getStartIdx());
        newContext.setEndIdx(this.getEndIdx());
        newContext.setFilterIdx(this.getFilterIdx());
        this.getAttributes().copyTo(newContext.getAttributes());
        FilterChainContext.notifyCopy(this, newContext, this.copyListeners);
        return newContext;
    }

    public void reset() {
        this.cachedInvokeAction.reset();
        this.cachedStopAction.reset();
        this.message = null;
        this.closeable = null;
        this.event = null;
        this.addressHolder = null;
        this.filterIdx = Integer.MIN_VALUE;
        this.state = State.RUNNING;
        this.operationCompletionHandler = null;
        this.operation = Operation.NONE;
        this.internalContext.reset();
        this.transportFilterContext.reset();
        this.copyListeners.clear();
        this.predefinedNextAction = null;
    }

    public void completeAndRecycle() {
        FilterChainContext.notifyComplete(this, this.completionListeners);
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public void completeAndRelease() {
        FilterChainContext.notifyComplete(this, this.completionListeners);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(384);
        sb.append("FilterChainContext [");
        sb.append("connection=").append(this.getConnection());
        sb.append(", closeable=").append(this.getCloseable());
        sb.append(", operation=").append((Object)this.getOperation());
        sb.append(", message=").append(String.valueOf((char[])this.getMessage()));
        sb.append(", address=").append(this.getAddress());
        sb.append(']');
        return sb.toString();
    }

    static Operation ioEvent2Operation(IOEvent ioEvent) {
        switch (ioEvent) {
            case READ: {
                return Operation.READ;
            }
            case WRITE: {
                return Operation.WRITE;
            }
            case ACCEPTED: {
                return Operation.ACCEPT;
            }
            case CONNECTED: {
                return Operation.CONNECT;
            }
            case CLOSED: {
                return Operation.CLOSE;
            }
        }
        return Operation.NONE;
    }

    static void notifyComplete(FilterChainContext context, List<CompletionListener> completionListeners) {
        int size = completionListeners.size();
        for (int i = size - 1; i >= 0; --i) {
            completionListeners.get(i).onComplete(context);
        }
        completionListeners.clear();
    }

    static void notifyCopy(FilterChainContext srcContext, FilterChainContext copiedContext, List<CopyListener> copyListeners) {
        int size = copyListeners.size();
        for (int i = 0; i < size; ++i) {
            copyListeners.get(i).onCopy(srcContext, copiedContext);
        }
    }

    public static interface CopyListener {
        public void onCopy(FilterChainContext var1, FilterChainContext var2);
    }

    public static interface CompletionListener {
        public void onComplete(FilterChainContext var1);
    }

    public static final class TransportContext {
        private boolean isBlocking;
        CompletionHandler completionHandler;
        @Deprecated
        PushBackHandler pushBackHandler;
        MessageCloner cloner;

        public void configureBlocking(boolean isBlocking) {
            this.isBlocking = isBlocking;
        }

        public boolean isBlocking() {
            return this.isBlocking;
        }

        public CompletionHandler getCompletionHandler() {
            return this.completionHandler;
        }

        public void setCompletionHandler(CompletionHandler completionHandler) {
            this.completionHandler = completionHandler;
        }

        @Deprecated
        public PushBackHandler getPushBackHandler() {
            return this.pushBackHandler;
        }

        @Deprecated
        public void setPushBackHandler(PushBackHandler pushBackHandler) {
            this.pushBackHandler = pushBackHandler;
        }

        public MessageCloner getMessageCloner() {
            return this.cloner;
        }

        public void setMessageCloner(MessageCloner cloner) {
            this.cloner = cloner;
        }

        void reset() {
            this.isBlocking = false;
            this.completionHandler = null;
            this.pushBackHandler = null;
            this.cloner = null;
        }
    }

    public static enum Operation {
        NONE,
        ACCEPT,
        CONNECT,
        READ,
        WRITE,
        EVENT,
        CLOSE;

    }

    public static enum State {
        RUNNING,
        SUSPEND;

    }
}

