/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http;

import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpResponsePacket;
import xyz.derkades.serverselectorx.lib.grizzly.http.ProcessingState;

class HttpResponsePacketImpl
extends HttpResponsePacket {
    private static final ThreadCache.CachedTypeIndex<HttpResponsePacketImpl> CACHE_IDX = ThreadCache.obtainIndex(HttpResponsePacketImpl.class, 16);

    public static HttpResponsePacketImpl create() {
        HttpResponsePacketImpl httpResponseImpl = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpResponseImpl != null) {
            return httpResponseImpl;
        }
        return new HttpResponsePacketImpl(){

            @Override
            public void recycle() {
                super.recycle();
                ThreadCache.putToCache(CACHE_IDX, this);
            }
        };
    }

    protected HttpResponsePacketImpl() {
    }

    @Override
    public ProcessingState getProcessingState() {
        return this.getRequest().getProcessingState();
    }

    @Override
    protected void reset() {
        super.reset();
    }

    @Override
    public void recycle() {
        if (this.getRequest().isExpectContent()) {
            return;
        }
        this.reset();
    }
}

