/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.nio;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.nio.DefaultSelectionKeyHandler;
import xyz.derkades.serverselectorx.lib.grizzly.nio.SelectionKeyHandler;

class SelectionKeyHandlerInitializer {
    private static final String PROP = "xyz.derkades.serverselectorx.lib.grizzly.DEFAULT_SELECTION_KEY_HANDLER";
    private static final Logger LOGGER = Grizzly.logger(SelectionKeyHandlerInitializer.class);

    SelectionKeyHandlerInitializer() {
    }

    static SelectionKeyHandler initHandler() {
        String className = System.getProperty(PROP);
        if (className != null) {
            try {
                Class<?> handlerClass = Class.forName(className, true, SelectionKeyHandler.class.getClassLoader());
                return (SelectionKeyHandler)handlerClass.newInstance();
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Unable to load or create a new instance of SelectionKeyHandler {0}.  Cause: {1}", new Object[]{className, e.getMessage()});
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.toString(), e);
                }
                return new DefaultSelectionKeyHandler();
            }
        }
        return new DefaultSelectionKeyHandler();
    }
}

