/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.transformation.inbuild;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import xyz.derkades.serverselectorx.lib.kyori.adventure.key.Key;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.Component;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.TextComponent;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.parser.ParsingException;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.parser.Token;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.parser.TokenType;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.transformation.Transformation;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.transformation.TransformationParser;
import xyz.derkades.serverselectorx.lib.kyori.examination.ExaminableProperty;

public final class FontTransformation
extends Transformation {
    private Key font;

    public static boolean canParse(String name) {
        return name.equalsIgnoreCase("font");
    }

    private FontTransformation() {
    }

    @Override
    public void load(String name, List<Token> args) {
        super.load(name, args);
        if (Token.oneString(args)) {
            this.font = Key.key(args.get(0).value());
        }
        if (args.size() != 3 || args.get(0).type() != TokenType.STRING || args.get(2).type() != TokenType.STRING) {
            throw new ParsingException("Doesn't know how to turn " + args + " into a click event", -1);
        }
        this.font = Key.key(args.get(0).value(), args.get(2).value());
    }

    @Override
    public Component apply(Component component, TextComponent.Builder parent) {
        return component.style(component.style().font(this.font));
    }

    @Override
    public @NonNull Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("font", this.font));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        FontTransformation that = (FontTransformation)other;
        return Objects.equals(this.font, that.font);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.font);
    }

    public static class Parser
    implements TransformationParser<FontTransformation> {
        @Override
        public FontTransformation parse() {
            return new FontTransformation();
        }
    }
}

