/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.ssx_connector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import xyz.derkades.ssx_connector.Addon;
import xyz.derkades.ssx_connector.BiFunction;
import xyz.derkades.ssx_connector.Main;
import xyz.derkades.ssx_connector.lib.derkutils.caching.Cache;

public class PlaceholderRegistry {
    private static final List<Placeholder> placeholders = new ArrayList<Placeholder>();

    public static void registerPlaceholder(Optional<Addon> addon, String key, BiFunction<UUID, String, String> valueFunction) {
        placeholders.add(new PlayerPlaceholder(key, addon, valueFunction));
    }

    public static void registerPlaceholder(Optional<Addon> addon, String key, Supplier<String> valueSupplier) {
        placeholders.add(new GlobalPlaceholder(key, addon, valueSupplier));
    }

    public static void unregisterAll(Addon addon) {
        ArrayList keysToRemove = new ArrayList();
        placeholders.stream().filter(p -> p.getAddon() == addon).forEach(keysToRemove::add);
        keysToRemove.forEach(placeholders::remove);
    }

    public static void clear() {
        placeholders.clear();
    }

    @Deprecated
    public static void forEach(Consumer<Placeholder> consumer) {
        placeholders.forEach(consumer);
    }

    public static Stream<Placeholder> stream() {
        return placeholders.stream();
    }

    static void collectPlaceholders(Map<UUID, String> players, Consumer<Map<String, Object>> consumer) {
        HashSet async = new HashSet(Main.instance.getConfig().getStringList("async"));
        HashMap placeholders = new HashMap();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            PlaceholderRegistry.stream().filter(p -> async.contains(p.getKey())).forEach(p -> {
                Object value = PlaceholderRegistry.getValue(p, players);
                if (value != null) {
                    placeholders.put(p.getKey(), value);
                }
            });
            Bukkit.getScheduler().runTask((Plugin)Main.instance, () -> {
                PlaceholderRegistry.stream().filter(p -> !async.contains(p.getKey())).forEach(p -> {
                    Object value = PlaceholderRegistry.getValue(p, players);
                    if (value != null) {
                        placeholders.put(p.getKey(), value);
                    }
                });
                consumer.accept(placeholders);
            });
        });
    }

    static Object getValue(Placeholder placeholder, Map<UUID, String> players) {
        Object value;
        try {
            value = placeholder instanceof PlayerPlaceholder ? players.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((PlayerPlaceholder)placeholder).getValue((UUID)e.getKey(), (String)e.getValue()))) : ((GlobalPlaceholder)placeholder).getValue();
            if (value == null) {
                if (placeholder.isFromAddon()) {
                    Main.instance.getLogger().warning(String.format("Placeholder %s from addon %s is null! This is either an addon bug or addon configuration issue.", placeholder.getKey(), placeholder.getAddon()));
                } else {
                    Main.instance.getLogger().warning(String.format("Placeholder %s is null! This is either a bug in the plugin that registered it or a configuration issue.", placeholder.getKey()));
                }
            }
        }
        catch (Exception e2) {
            Main.instance.getLogger().warning("An error occured while retrieving placeholder " + placeholder.getKey() + ". This is probably a bug in the plugin or expansion that added this placeholder (not in SSX-Connector).");
            Main.instance.getLogger().warning("Note that not all plugins work properly when no players are online on a server.");
            e2.printStackTrace();
            value = null;
        }
        return value;
    }

    public static abstract class Placeholder {
        private final String key;
        private final Optional<Addon> addon;

        private Placeholder(String key, Optional<Addon> addon) {
            this.key = key;
            this.addon = addon;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isFromAddon() {
            return this.addon.isPresent();
        }

        public Addon getAddon() {
            return this.addon.get();
        }
    }

    public static class GlobalPlaceholder
    extends Placeholder {
        private final Supplier<String> valueSupplier;

        private GlobalPlaceholder(String key, Optional<Addon> addon, Supplier<String> valueSupplier) {
            super(key, addon);
            this.valueSupplier = valueSupplier;
        }

        public String getValue() {
            if (Main.cacheEnabled) {
                Optional cache = Cache.get("ssxplaceholder" + this.getKey());
                if (cache.isPresent()) {
                    ++Main.placeholdersCached;
                    return (String)cache.get();
                }
                ++Main.placeholdersUncached;
                String value = this.valueSupplier.get();
                int timeout = Main.instance.getConfig().getInt("cache." + this.getKey(), Main.instance.getConfig().getInt("default-cache-time", 1));
                Cache.set("ssxplaceholder" + this.getKey(), value, timeout);
                return value;
            }
            ++Main.placeholdersUncached;
            return this.valueSupplier.get();
        }
    }

    public static class PlayerPlaceholder
    extends Placeholder {
        private final BiFunction<UUID, String, String> function;

        private PlayerPlaceholder(String key, Optional<Addon> addon, BiFunction<UUID, String, String> function) {
            super(key, addon);
            this.function = function;
        }

        public String getValue(UUID uuid, String name) {
            if (Main.cacheEnabled) {
                Optional cache = Cache.get("ssxplaceholder" + name + this.getKey());
                if (cache.isPresent()) {
                    ++Main.placeholdersCached;
                    return (String)cache.get();
                }
                ++Main.placeholdersUncached;
                String value = this.function.apply(uuid, name);
                int timeout = Main.instance.getConfig().getInt("cache." + this.getKey(), Main.instance.getConfig().getInt("default-cache-time", 1));
                Cache.set("ssxplaceholder" + name + this.getKey(), value, timeout);
                return value;
            }
            ++Main.placeholdersUncached;
            return this.function.apply(uuid, name);
        }
    }
}

