/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.ssx_connector;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import xyz.derkades.ssx_connector.Addon;
import xyz.derkades.ssx_connector.ConnectorCommand;
import xyz.derkades.ssx_connector.PlaceholderRegistry;
import xyz.derkades.ssx_connector.PlaceholderSender;
import xyz.derkades.ssx_connector.lib.bstats.bukkit.Metrics;
import xyz.derkades.ssx_connector.lib.bstats.charts.AdvancedPie;
import xyz.derkades.ssx_connector.lib.bstats.charts.SimplePie;
import xyz.derkades.ssx_connector.lib.derkutils.caching.Cache;

public class Main
extends JavaPlugin {
    static Main instance;
    static int placeholdersUncached;
    static int placeholdersCached;
    static int sendAmount;
    static boolean cacheEnabled;
    final File addonsFolder = new File(this.getDataFolder(), "addons");
    Map<String, Addon> addons = new HashMap<String, Addon>();
    private BukkitTask pingTask = null;

    public void onEnable() {
        instance = this;
        super.saveDefaultConfig();
        this.addonsFolder.mkdir();
        this.loadAddons();
        this.getCommand("ssxc").setExecutor((CommandExecutor)new ConnectorCommand());
        this.restartPingTask();
        this.registerMetrics();
        this.getServer().getScheduler().runTaskTimer((Plugin)this, () -> Cache.cleanCache(), 72000L, 72000L);
    }

    void loadAddons() {
        PlaceholderRegistry.clear();
        File addonsFolder = new File(this.getDataFolder() + File.separator + "addons");
        addonsFolder.mkdirs();
        HashSet<String> newlyLoadedAddons = new HashSet<String>();
        for (File addonFile : addonsFolder.listFiles()) {
            if (addonFile.isDirectory()) {
                this.getLogger().warning("Skipped directory " + addonFile.getPath() + " in addons directory. There should not be any directories in the addon directory.");
                continue;
            }
            if (!addonFile.getName().endsWith(".class")) {
                if (addonFile.getName().endsWith(".yml")) continue;
                this.getLogger().warning("The file " + addonFile.getAbsolutePath() + " does not belong in the addons folder.");
                continue;
            }
            String addonName = addonFile.getName().replace(".class", "");
            Addon addon = this.addons.get(addonName);
            if (addon == null) {
                this.getLogger().info("Loading addon " + addonName);
                try (URLClassLoader loader = new URLClassLoader(new URL[]{addonsFolder.toURI().toURL()}, this.getClassLoader());){
                    Class<?> clazz = loader.loadClass(addonFile.getName().replace(".class", ""));
                    addon = (Addon)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (!addon.getName().equals(addonName)) {
                this.getLogger().severe(String.format("Addon class name (%s) does not match class file name (%s)", addon.getName(), addonName));
                continue;
            }
            addon.reloadConfig();
            addon.onLoad();
            this.addons.put(addonName, addon);
            newlyLoadedAddons.add(addonName);
        }
        ArrayDeque<String> toRemove = new ArrayDeque<String>();
        for (String addonName : this.addons.keySet()) {
            if (newlyLoadedAddons.contains(addonName)) continue;
            this.getLogger().info("Uninstalling addon " + addonName);
            toRemove.add(addonName);
        }
        while (!toRemove.isEmpty()) {
            this.addons.remove(toRemove.pop());
        }
        this.registerCorePlaceholders();
    }

    void registerCorePlaceholders() {
        PlaceholderRegistry.registerPlaceholder(Optional.empty(), "online", () -> String.valueOf(Bukkit.getOnlinePlayers().size()));
        PlaceholderRegistry.registerPlaceholder(Optional.empty(), "max", () -> String.valueOf(Bukkit.getMaxPlayers()));
    }

    void restartPingTask() {
        if (this.pingTask != null) {
            this.pingTask.cancel();
        }
        int addresses = this.getConfig().getStringList("addresses").size();
        int interval = this.getConfig().getInt("send-interval");
        int taskIntervalTicks = interval * 20 / addresses;
        this.pingTask = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this, (Runnable)new PlaceholderSender(), 40L, (long)taskIntervalTicks);
    }

    public void reloadConfig() {
        super.reloadConfig();
        cacheEnabled = this.getConfig().getBoolean("enable-caching", true);
    }

    private void registerMetrics() {
        Metrics metrics = new Metrics(this, 3000);
        metrics.addCustomChart(new SimplePie("data_send_interval", () -> this.getConfig().getInt("send-interval", 4) + ""));
        metrics.addCustomChart(new SimplePie("hub_servers", () -> this.getConfig().getStringList("addresses").size() + ""));
        metrics.addCustomChart(new SimplePie("default_password", () -> this.getConfig().getString("password").equals("a") + ""));
        metrics.addCustomChart(new AdvancedPie("addons", () -> {
            HashMap map = new HashMap();
            this.addons.forEach((ign, a) -> map.put(a.getName(), 1));
            return map;
        }));
    }

    static {
        placeholdersUncached = 0;
        placeholdersCached = 0;
        sendAmount = 0;
        cacheEnabled = true;
    }
}

