/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.ssx_connector;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;

public class PingLogger {
    private static final Map<String, PingStatus> map = new ConcurrentHashMap<String, PingStatus>();

    public static void logSuccess(String address) {
        map.put(address, new PingSuccess(System.currentTimeMillis()));
    }

    public static void logFail(String address, String message) {
        map.put(address, new PingFail(System.currentTimeMillis(), message));
    }

    public static Set<Map.Entry<String, PingStatus>> entries() {
        return map.entrySet();
    }

    public static boolean isEmpty() {
        return map.isEmpty();
    }

    public static void forEach(BiConsumer<String, PingStatus> consumer) {
        map.forEach(consumer);
    }

    public static void clear() {
        map.clear();
    }

    public static abstract class PingStatus {
        private final long time;

        private PingStatus(long time) {
            this.time = time;
        }

        public long getTime() {
            return this.time;
        }
    }

    public static final class PingSuccess
    extends PingStatus {
        private PingSuccess(long time) {
            super(time);
        }
    }

    public static final class PingFail
    extends PingStatus {
        private final String message;

        private PingFail(long time, String message) {
            super(time);
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

