/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.ssx_connector.lib.derkutils.caching;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import xyz.derkades.ssx_connector.lib.derkutils.caching.CacheObject;

public class Cache {
    private static final int DEFAULT_CACHE_DURATION = 60;
    private static final Map<String, CacheObject> CACHE_OBJECT_MAP = new ConcurrentHashMap<String, CacheObject>();

    public static void set(@NotNull String identifier, @NotNull Object object, long timeout) {
        Objects.requireNonNull(identifier, "identifier is null");
        Objects.requireNonNull(object, "object to cache is null");
        if (timeout <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        CacheObject cachedObject = new CacheObject(object, timeout);
        CACHE_OBJECT_MAP.put(identifier, cachedObject);
    }

    public static void set(String identifier, Object object) {
        Cache.set(identifier, object, 60L);
    }

    public static <T> Optional<T> get(@NotNull String identifier) {
        Objects.requireNonNull(identifier, "identifier is null");
        CacheObject cache = CACHE_OBJECT_MAP.get(identifier);
        if (cache == null) {
            return Optional.empty();
        }
        if (cache.expire < System.currentTimeMillis()) {
            CACHE_OBJECT_MAP.remove(identifier);
            return Optional.empty();
        }
        Object t = cache.object;
        return Optional.of(t);
    }

    public static void remove(@NotNull String identifier) {
        CACHE_OBJECT_MAP.remove(Objects.requireNonNull(identifier, "identifier is null"));
    }

    public static int cleanCache() {
        ArrayDeque toRemove = new ArrayDeque();
        CACHE_OBJECT_MAP.forEach((k, v) -> {
            if (v.expire < System.currentTimeMillis()) {
                toRemove.push(k);
            }
        });
        int i = toRemove.size();
        while (!toRemove.isEmpty()) {
            Cache.remove((String)toRemove.pop());
        }
        return i;
    }

    public static int size() {
        return CACHE_OBJECT_MAP.size();
    }

    @Deprecated
    public static void addCachedObject(String identifier, Object object, long timeout) {
        Cache.set(identifier, object, timeout);
    }

    @Deprecated
    public static void addCachedObject(String identifier, Object object) {
        Cache.set(identifier, object);
    }

    @Deprecated
    public static Object getCachedObject(String identifier) {
        CacheObject cache = CACHE_OBJECT_MAP.get(identifier);
        if (cache == null) {
            return null;
        }
        if (cache.expire < System.currentTimeMillis()) {
            CACHE_OBJECT_MAP.remove(identifier);
            return null;
        }
        return cache.object;
    }

    @Deprecated
    public static void removeCachedObject(String identifier) {
        CACHE_OBJECT_MAP.remove(identifier);
    }
}

