/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.derkades.serverselectorx.ActionsOnJoinListener;
import xyz.derkades.serverselectorx.BetaMessageJoinListener;
import xyz.derkades.serverselectorx.Commands;
import xyz.derkades.serverselectorx.HDBHandler;
import xyz.derkades.serverselectorx.ItemClickListener;
import xyz.derkades.serverselectorx.ItemGiveListener;
import xyz.derkades.serverselectorx.ItemMoveDropCancelListener;
import xyz.derkades.serverselectorx.ServerSelectorX;
import xyz.derkades.serverselectorx.ServerSelectorXCommand;
import xyz.derkades.serverselectorx.ServerSelectorXCommandCompleter;
import xyz.derkades.serverselectorx.Stats;
import xyz.derkades.serverselectorx.WebServer;
import xyz.derkades.serverselectorx.configuration.ConfigSync;
import xyz.derkades.serverselectorx.configuration.ConfigurationManager;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.NbtItemBuilder;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.PlaceholderUtil;
import xyz.derkades.serverselectorx.lib.gson.Gson;
import xyz.derkades.serverselectorx.lib.gson.GsonBuilder;
import xyz.derkades.serverselectorx.lib.gson.JsonObject;
import xyz.derkades.serverselectorx.lib.gson.JsonParser;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.Nullable;
import xyz.derkades.serverselectorx.lib.kyori.adventure.platform.bukkit.BukkitAudiences;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.Component;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.MiniMessage;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTCompound;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTContainer;
import xyz.derkades.serverselectorx.lib.nbtapi.NbtApiException;
import xyz.derkades.serverselectorx.lib.nbtapi.utils.MinecraftVersion;
import xyz.derkades.serverselectorx.placeholders.PapiExpansionRegistrar;
import xyz.derkades.serverselectorx.placeholders.Server;

public class Main
extends JavaPlugin {
    static boolean ITEM_DEBUG;
    private static ConfigurationManager configurationManager;
    private static ConfigSync configSync;
    private static Main plugin;
    private static BukkitAudiences adventure;
    public static WebServer server;
    public static final Gson GSON;
    private static final Map<UUID, String> HEAD_TEXTURE_CACHE;
    private static final LegacyComponentSerializer LEGACY_COMPONENT_SERIALIZER;

    @NotNull
    public static Main getPlugin() {
        return plugin;
    }

    public void onEnable() {
        plugin = this;
        MinecraftVersion.replaceLogger(this.getLogger());
        configurationManager = new ConfigurationManager();
        try {
            configurationManager.reload();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
        this.getCommand("serverselectorx").setExecutor((CommandExecutor)new ServerSelectorXCommand());
        this.getCommand("serverselectorx").setTabCompleter((TabCompleter)new ServerSelectorXCommandCompleter());
        Commands.registerCustomCommands();
        adventure = BukkitAudiences.create((Plugin)this);
        server = new WebServer();
        server.start();
        configSync = new ConfigSync();
        new Stats();
        new ItemMoveDropCancelListener();
        Bukkit.getPluginManager().registerEvents((Listener)new ItemClickListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ItemGiveListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new BetaMessageJoinListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ActionsOnJoinListener(), (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            PapiExpansionRegistrar.register();
        }
    }

    public void onDisable() {
        if (adventure != null) {
            adventure.close();
            adventure = null;
        }
        if (server != null) {
            server.stop();
        }
    }

    public static ConfigurationManager getConfigurationManager() {
        return configurationManager;
    }

    static ConfigSync getConfigSync() {
        return configSync;
    }

    public static BukkitAudiences adventure() {
        return adventure;
    }

    public static void getItemBuilderFromItemSection(@NotNull Player player, @NotNull ConfigurationSection section, @NotNull Consumer<NbtItemBuilder> itemConsumer) {
        String materialString = section.getString("material");
        Main.getItemBuilderFromMaterialString(player, materialString, builder -> {
            boolean useMiniMessage = section.getBoolean("minimessage", false);
            PlaceholderUtil.Placeholder playerPlaceholder = new PlaceholderUtil.Placeholder("{player}", player.getName());
            PlaceholderUtil.Placeholder globalOnlinePlaceholder = new PlaceholderUtil.Placeholder("{globalOnline}", String.valueOf(ServerSelectorX.getGlobalPlayerCount()));
            PlaceholderUtil.Placeholder[] additionalPlaceholders = new PlaceholderUtil.Placeholder[]{playerPlaceholder, globalOnlinePlaceholder};
            if (section.contains("title")) {
                Object title = section.getString("title");
                title = PlaceholderUtil.parsePapiPlaceholders(player, (String)title, additionalPlaceholders);
                if (useMiniMessage) {
                    Object c = MiniMessage.miniMessage().deserialize(title);
                    title = LEGACY_COMPONENT_SERIALIZER.serialize((Component)c);
                    builder.name((String)title);
                } else {
                    title = "&r&f" + (String)title;
                    builder.coloredName((String)title);
                }
            } else {
                builder.name(" ");
            }
            if (section.contains("lore")) {
                ArrayList<String> lore = new ArrayList<String>(section.getStringList("lore"));
                for (int i = 0; i < lore.size(); ++i) {
                    Object line = (String)lore.get(i);
                    line = PlaceholderUtil.parsePapiPlaceholders(player, (String)line, additionalPlaceholders);
                    if (useMiniMessage) {
                        Object c = MiniMessage.miniMessage().deserialize(line);
                        line = LEGACY_COMPONENT_SERIALIZER.serialize((Component)c);
                    } else {
                        line = "&r&f" + (String)line;
                    }
                    lore.set(i, (String)line);
                }
                if (useMiniMessage) {
                    builder.lore(lore);
                } else {
                    builder.coloredLore(lore);
                }
            }
            boolean hideFlagsDefault = false;
            if (section.getBoolean("enchanted")) {
                builder.unsafeEnchant(Enchantment.DURABILITY, 1);
                hideFlagsDefault = true;
            }
            if (section.getBoolean("hide-flags", hideFlagsDefault)) {
                builder.hideFlags();
            }
            if (section.isInt("amount")) {
                builder.amount(section.getInt("amount"));
            }
            if (section.isInt("durability")) {
                builder.damage(section.getInt("durability"));
            }
            if (section.isString("nbt")) {
                try {
                    NBTContainer container = new NBTContainer(section.getString("nbt"));
                    Object compound = container.getCompound();
                    if (compound instanceof NBTCompound) {
                        builder.editNbt(nbt -> nbt.mergeCompound((NBTCompound)compound));
                    } else {
                        player.sendMessage("Custom NBT is not a compound? " + compound.getClass().getSimpleName());
                    }
                }
                catch (NbtApiException e) {
                    player.sendMessage("Skipped adding custom NBT to an item because of an error, please see the console for more info.");
                    e.printStackTrace();
                }
            }
            itemConsumer.accept((NbtItemBuilder)builder);
        });
    }

    private static void getItemBuilderFromMaterialString(Player player, @Nullable String materialString, Consumer<NbtItemBuilder> builderConsumer) {
        if (materialString == null) {
            return;
        }
        if (materialString.charAt(0) == '!') {
            materialString = PlaceholderUtil.parsePapiPlaceholders(player, materialString.substring(1));
        }
        if (materialString.startsWith("head:")) {
            String owner = materialString.split(":")[1];
            if (owner.equals("auto")) {
                if (Main.getConfigurationManager().getMiscConfiguration().getBoolean("mojang-api-head-auto", false)) {
                    Main.getHeadTexture(player.getUniqueId(), texture -> {
                        if (texture != null) {
                            builderConsumer.accept(new NbtItemBuilder(Material.PLAYER_HEAD).skullTexture((String)texture));
                        } else {
                            builderConsumer.accept(new NbtItemBuilder(Material.PLAYER_HEAD));
                        }
                    });
                } else {
                    builderConsumer.accept((NbtItemBuilder)new NbtItemBuilder(Material.PLAYER_HEAD).skullOwner((OfflinePlayer)player));
                }
            } else {
                try {
                    UUID ownerUuid = UUID.fromString(owner);
                    Main.getHeadTexture(ownerUuid, texture -> {
                        if (texture != null) {
                            builderConsumer.accept(new NbtItemBuilder(Material.PLAYER_HEAD).skullTexture((String)texture));
                        } else {
                            builderConsumer.accept(new NbtItemBuilder(Material.PLAYER_HEAD));
                        }
                    });
                }
                catch (IllegalArgumentException e) {
                    builderConsumer.accept(new NbtItemBuilder(Material.PLAYER_HEAD).skullTexture(owner));
                }
            }
            return;
        }
        if (materialString.startsWith("hdb")) {
            String id = materialString.substring(4);
            builderConsumer.accept(HDBHandler.getBuilder(id));
            return;
        }
        String[] materialsToTry = materialString.split("\\|");
        Material material = null;
        for (String materialString2 : materialsToTry) {
            try {
                material = Material.valueOf((String)materialString2);
                break;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        if (material == null) {
            player.sendMessage("Invalid item name '" + materialString + "'");
            player.sendMessage("https://github.com/ServerSelectorX/ServerSelectorX/wiki/Item-names");
            return;
        }
        if (material != Material.AIR) {
            builderConsumer.accept(new NbtItemBuilder(material));
        }
    }

    public static void getHeadTexture(UUID uuid, Consumer<String> textureConsumer) {
        if (HEAD_TEXTURE_CACHE.containsKey(uuid)) {
            textureConsumer.accept(HEAD_TEXTURE_CACHE.get(uuid));
        }
        Main.getPlugin().getLogger().info("Getting texture value for " + uuid + " from Mojang API");
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getPlugin(), () -> {
            try {
                HttpURLConnection connection = (HttpURLConnection)new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString()).openConnection();
                try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                    JsonObject jsonResponse = (JsonObject)JsonParser.parseReader(reader);
                    String texture = jsonResponse.get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                    HEAD_TEXTURE_CACHE.put(uuid, texture);
                    Main.getPlugin().getLogger().info("Got " + texture);
                    Bukkit.getScheduler().runTask((Plugin)Main.getPlugin(), () -> textureConsumer.accept(texture));
                }
            }
            catch (IOException | ClassCastException | IllegalArgumentException | IllegalStateException | IndexOutOfBoundsException | NullPointerException e) {
                Main.getPlugin().getLogger().warning("Failed to get base64 texture value for " + uuid + ". Is the UUID valid? Error details: " + e.getClass().getSimpleName() + " " + e.getMessage());
            }
        });
    }

    static {
        MinecraftVersion.disableUpdateCheck();
        ITEM_DEBUG = false;
        GSON = new GsonBuilder().registerTypeAdapter((Type)((Object)Server.class), Server.SERIALIZER).create();
        HEAD_TEXTURE_CACHE = new HashMap<UUID, String>();
        LEGACY_COMPONENT_SERIALIZER = LegacyComponentSerializer.builder().character('\u00a7').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    }
}

