/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.actions.Action;
import xyz.derkades.serverselectorx.lib.derkutils.Cooldown;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.Colors;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.NbtItemBuilder;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.IconMenu;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.MenuCloseEvent;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.menu.OptionClickEvent;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.Nullable;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTItem;
import xyz.derkades.serverselectorx.placeholders.GlobalPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Placeholder;
import xyz.derkades.serverselectorx.placeholders.PlayerPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Server;

public class Menu
extends IconMenu {
    private final FileConfiguration config;
    private boolean closed = false;

    public Menu(final Player player, final @Nullable FileConfiguration config, String configName) {
        super((Plugin)Main.getPlugin(), config == null ? "error" : Colors.parseColors(config.getString("title", "TITLE MISSING")), config == null ? 1 : config.getInt("rows", 6), player);
        this.config = config;
        if (this.config == null || this.config.getConfigurationSection("menu") == null) {
            player.sendMessage("The configuration file failed to load, probably due to a syntax error.");
            player.sendMessage("Take a look at the console for any YAML errors, or paste your config in http://www.yamllint.com/");
            player.sendMessage("Check for identation and balanced quotes. If you want to use quotation marks in strings, they must be escaped properly by putting two quotation marks (for example \"\" or '').");
            player.sendMessage("Menu name: " + configName);
            return;
        }
        try {
            if (config.contains("sound")) {
                player.playSound(player.getLocation(), Sound.valueOf((String)config.getString("sound")), 1.0f, 1.0f);
            }
        }
        catch (IllegalArgumentException e) {
            Main.getPlugin().getLogger().warning("Invalid sound name in config file '" + configName + "'");
            Main.getPlugin().getLogger().warning("https://github.com/ServerSelectorX/ServerSelectorX/wiki/Sound-names");
        }
        int updateInterval = config.getInt("update-interval", 100);
        new BukkitRunnable(){

            public void run() {
                if (Menu.this.closed || Bukkit.getPlayer((String)player.getName()) == null) {
                    this.cancel();
                    return;
                }
                Menu.this.addItems();
                if (config.getBoolean("disable-updates", false)) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)updateInterval);
    }

    private void addItems() {
        FileConfiguration configMisc = Main.getConfigurationManager().getMiscConfiguration();
        OfflinePlayer potentiallyOffline = this.getPlayer();
        if (!(potentiallyOffline instanceof Player)) {
            Main.getPlugin().getLogger().warning("Player " + potentiallyOffline.getUniqueId() + " went offline?");
            return;
        }
        Player player = (Player)potentiallyOffline;
        block0: for (String key : this.config.getConfigurationSection("menu").getKeys(false)) {
            if (!this.config.isConfigurationSection("menu." + key)) {
                player.sendMessage("Invalid item " + key + ", check indentation.");
                continue;
            }
            ConfigurationSection section = Objects.requireNonNull(this.config.getConfigurationSection("menu." + key), "Null configuration section: menu." + key);
            Object chosenSection = null;
            int amountOverride = -1;
            HashMap<CallSite, String> placeholders = null;
            if (section.isString("permission") && !player.hasPermission(Objects.requireNonNull(section.getString("permission"), "null permission"))) {
                ConfigurationSection noPermissionSection = section.getConfigurationSection("no-permission");
                if (noPermissionSection == null) {
                    player.sendMessage("Missing no-permission section for item " + key + ". Remove the permission option or add a no-permission section.");
                    return;
                }
                String materialString = noPermissionSection.getString("material");
                if (materialString == null) {
                    player.sendMessage("No permission section is missing the material option");
                    return;
                }
                if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                chosenSection = noPermissionSection;
            } else if (section.isString("connector")) {
                String materialString;
                String serverName = Objects.requireNonNull(section.getString("connector"), "connector server name null");
                Server server = Server.getServer(serverName);
                if (server.isOnline()) {
                    if (section.isConfigurationSection("connected")) {
                        if (!configMisc.contains("server-name")) {
                            player.sendMessage("To use the connected section, specify server-name in misc.yml");
                            return;
                        }
                        if (serverName.equalsIgnoreCase(configMisc.getString("server-name"))) {
                            chosenSection = section.getConfigurationSection("connected");
                        }
                    }
                    if (chosenSection == null && section.isConfigurationSection("dynamic")) {
                        for (String dynamicKey : section.getConfigurationSection("dynamic").getKeys(false)) {
                            ConfigurationSection dynamicSection;
                            String mode;
                            String placeholderValueFromConnector;
                            String[] split = dynamicKey.split(":");
                            if (split.length != 2) {
                                player.sendMessage("Invalid dynamic section '" + dynamicKey + "'. Dynamic section identifiers should contain exactly one colon.");
                                return;
                            }
                            String placeholderKeyInConfig = split[0];
                            String placeholderValueInConfig = split[1];
                            Placeholder placeholder = server.getPlaceholder(placeholderKeyInConfig);
                            if (placeholder == null) {
                                Main.getPlugin().getLogger().warning("Dynamic feature contains rule with placeholder " + placeholderKeyInConfig + " which has not been received from the server.");
                                continue;
                            }
                            if (placeholder instanceof GlobalPlaceholder) {
                                GlobalPlaceholder global = (GlobalPlaceholder)placeholder;
                                placeholderValueFromConnector = global.getValue();
                            } else {
                                PlayerPlaceholder playerPlaceholder = (PlayerPlaceholder)placeholder;
                                placeholderValueFromConnector = playerPlaceholder.getValue((OfflinePlayer)player);
                            }
                            if (!((mode = (dynamicSection = section.getConfigurationSection("dynamic." + dynamicKey)).getString("mode", "equals")).equals("equals") && placeholderValueInConfig.equals(placeholderValueFromConnector) || mode.equals("less") && Double.parseDouble(placeholderValueInConfig) > Double.parseDouble(placeholderValueFromConnector)) && (!mode.equals("more") || !(Double.parseDouble(placeholderValueInConfig) < Double.parseDouble(placeholderValueFromConnector)))) continue;
                            String materialString2 = dynamicSection.getString("material");
                            if (materialString2 == null) {
                                player.sendMessage("Dynamic section '" + dynamicKey + "' is missing the material option");
                                return;
                            }
                            if (materialString2.equals("NONE") || materialString2.equals("AIR")) continue block0;
                            chosenSection = dynamicSection;
                            break;
                        }
                    }
                    if (chosenSection == null) {
                        if (!section.isConfigurationSection("online")) {
                            player.sendMessage("Error for item " + key);
                            player.sendMessage("Online section does not exist");
                            return;
                        }
                        ConfigurationSection onlineSection = section.getConfigurationSection("online");
                        materialString = onlineSection.getString("material");
                        if (materialString == null) {
                            player.sendMessage("Error for item " + key);
                            player.sendMessage("Online section does not have a material option");
                        }
                        if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                        chosenSection = onlineSection;
                    }
                    placeholders = new HashMap<CallSite, String>();
                    for (Placeholder placeholder : server.getPlaceholders()) {
                        String value;
                        if (placeholder instanceof GlobalPlaceholder) {
                            GlobalPlaceholder global = (GlobalPlaceholder)placeholder;
                            value = global.getValue();
                        } else {
                            PlayerPlaceholder playerPlaceholder = (PlayerPlaceholder)placeholder;
                            value = playerPlaceholder.getValue((OfflinePlayer)player);
                        }
                        placeholders.put((CallSite)((Object)("{" + placeholder.getKey() + "}")), value);
                    }
                    if (section.getBoolean("dynamic-item-count", false)) {
                        int amount = server.getOnlinePlayers();
                        amountOverride = amount < 1 || amount > 64 ? 1 : amount;
                    }
                } else {
                    if (!section.isConfigurationSection("offline")) {
                        player.sendMessage("Offline section does not exist");
                        return;
                    }
                    ConfigurationSection offlineSection = section.getConfigurationSection("offline");
                    materialString = offlineSection.getString("material");
                    if (materialString == null) {
                        player.sendMessage("Error for item " + key);
                        player.sendMessage("Offline section does not have a material option");
                    }
                    if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                    chosenSection = offlineSection;
                }
            } else {
                String materialString = section.getString("material");
                if (materialString == null) {
                    player.sendMessage("Error for item " + key);
                    player.sendMessage("Missing material option. Remember, this is not an advanced section, so don't use online/offline/dynamic sections in the config.");
                    player.sendMessage("If you want to use these sections, add a connector option.");
                    player.sendMessage("Read more here: https://github.com/ServerSelectorX/ServerSelectorX/wiki/Menu-items-v2");
                }
                if (materialString.equals("NONE") || materialString.equals("AIR")) continue;
                chosenSection = section;
            }
            ConfigurationSection chosenSectionFinal = chosenSection;
            int amountOverrideFinal = amountOverride;
            HashMap<CallSite, String> placeholdersFinal = placeholders;
            Main.getItemBuilderFromItemSection(player, chosenSection, builder -> {
                if (amountOverrideFinal >= 0) {
                    builder.amount(amountOverrideFinal);
                }
                if (placeholdersFinal != null) {
                    ((NbtItemBuilder)builder.namePlaceholders(placeholdersFinal)).lorePlaceholders(placeholdersFinal);
                }
                this.addToMenu(key, player, chosenSectionFinal, (NbtItemBuilder)builder);
            });
        }
    }

    public void addToMenu(String key, Player player, ConfigurationSection section, NbtItemBuilder builder) {
        builder.editNbt(nbt -> {
            nbt.setObject("SSXActions", section.getStringList("actions"));
            nbt.setObject("SSXActionsLeft", section.getStringList("left-click-actions"));
            nbt.setObject("SSXActionsRight", section.getStringList("right-click-actions"));
            if (section.contains("cooldown")) {
                if (!section.isList("cooldown-actions")) {
                    player.sendMessage("When using the 'cooldown' option, a list of actions 'cooldown-actions' must also be specified.");
                    return;
                }
                nbt.setInteger("SSXCooldownTime", (int)(section.getDouble("cooldown") * 1000.0));
                nbt.setString("SSXCooldownId", player.getName() + this.getInventoryView().getTitle() + key);
                nbt.setObject("SSXCooldownActions", section.getStringList("cooldown-actions"));
            }
        });
        ItemStack item = builder.create();
        if (key.equals("fill") || key.equals("-1")) {
            for (int i = 0; i < this.getInventory().getSize(); ++i) {
                if (this.hasItem(i)) continue;
                this.addItem(i, item);
            }
        } else {
            for (String split : key.split(",")) {
                int slot;
                try {
                    slot = Integer.parseInt(split);
                }
                catch (NumberFormatException e) {
                    player.sendMessage("Invalid slot number " + split);
                    return;
                }
                if (slot >= this.getInventory().getSize() || slot < 0) {
                    player.sendMessage("You put an item in slot " + slot + ", which is higher than the maximum number of slots in your menu.");
                    player.sendMessage("Use numbers 0 to " + (this.getInventory().getSize() - 1) + "or increase the number of rows in the config");
                    return;
                }
                this.addItem(slot, item);
            }
        }
    }

    @Override
    public boolean onOptionClick(OptionClickEvent event) {
        boolean leftClick;
        Player player = event.getPlayer();
        NBTItem nbt = new NBTItem(event.getItemStack());
        List actions = nbt.getObject("SSXActions", List.class);
        List leftActions = nbt.getObject("SSXActionsLeft", List.class);
        List rightActions = nbt.getObject("SSXActionsRight", List.class);
        ClickType click = event.getClickType();
        boolean rightClick = click == ClickType.RIGHT || click == ClickType.SHIFT_RIGHT;
        boolean bl = leftClick = click == ClickType.LEFT || click == ClickType.SHIFT_LEFT;
        if (nbt.hasKey("SSXCooldownTime").booleanValue() && (!actions.isEmpty() || rightClick && !rightActions.isEmpty() || leftClick && !leftActions.isEmpty())) {
            int cooldownTime = nbt.getInteger("SSXCooldownTime");
            String cooldownId = nbt.getString("SSXCooldownId");
            if (Cooldown.getCooldown(cooldownId) > 0L) {
                List cooldownActions = nbt.getObject("SSXCooldownActions", List.class);
                return Action.runActions(player, cooldownActions);
            }
            Cooldown.addCooldown(cooldownId, cooldownTime);
        }
        boolean close = Action.runActions(player, actions);
        if (rightClick) {
            close = close || Action.runActions(player, rightActions);
        } else if (leftClick) {
            close = close || Action.runActions(player, leftActions);
        }
        return close;
    }

    @Override
    public void onClose(MenuCloseEvent event) {
        String reason;
        this.closed = true;
        Cooldown.addCooldown("ssxitemglobal" + this.getPlayer().getName(), 100L);
        if (!this.config.contains("on-close")) {
            return;
        }
        switch (event.getReason()) {
            case PLAYER_CLOSED: {
                reason = "player";
                break;
            }
            case ITEM_CLICK: {
                reason = "item";
                break;
            }
            case PLAYER_QUIT: {
                reason = "quit";
                break;
            }
            default: {
                reason = null;
            }
        }
        if (reason == null) {
            return;
        }
        this.config.getMapList("on-close").forEach(map -> {
            List reasons = (List)map.get("reasons");
            if (reasons.contains(reason)) {
                List actions = (List)map.get("actions");
                if (event.getOfflinePlayer() instanceof Player) {
                    Action.runActions(event.getPlayer(), actions);
                } else {
                    Action.runActions(null, actions);
                }
            }
        });
    }
}

