/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import xyz.derkades.serverselectorx.Commands;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.Menu;
import xyz.derkades.serverselectorx.ServerSelectorX;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.placeholders.GlobalPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Placeholder;
import xyz.derkades.serverselectorx.placeholders.PlayerPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Server;

public class ServerSelectorXCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!sender.hasPermission("ssx.admin")) {
            sender.sendMessage(ChatColor.RED + "You need the permission 'ssx.admin' to execute this command.");
            return true;
        }
        if (args.length == 3 && args[0].equals("openmenu")) {
            String menuName = args[1];
            String playerName = args[2];
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) {
                sender.sendMessage("No online player found with name '" + playerName + "'.");
                return true;
            }
            FileConfiguration config = Main.getConfigurationManager().getMenuConfiguration(menuName);
            if (config != null) {
                sender.sendMessage("No menu exists with name '" + menuName + "'.");
                sender.sendMessage("The menu name is the name of the menu file, without its extension.");
                sender.sendMessage("For example, for a menu file called 'serverselector.yml', enter 'serverselector'.");
                return true;
            }
            new Menu(player, config, menuName);
            return true;
        }
        if (args.length == 2 && args[0].equals("placeholders")) {
            String serverName = args[1];
            Server server = Server.getServer(serverName);
            if (!server.isOnline()) {
                sender.sendMessage("The server '" + serverName + "' does not exist or is currently offline");
                return true;
            }
            sender.sendMessage("Placeholders for " + serverName);
            for (Placeholder placeholder : server.getPlaceholders()) {
                if (placeholder instanceof PlayerPlaceholder) {
                    sender.sendMessage(placeholder.getKey());
                    PlayerPlaceholder pp = (PlayerPlaceholder)placeholder;
                    pp.getValues().forEach((uuid, value) -> sender.sendMessage("  " + uuid + ": " + value));
                    continue;
                }
                sender.sendMessage(placeholder.getKey() + ": " + ((GlobalPlaceholder)placeholder).getValue());
            }
            return true;
        }
        if (args.length == 1) {
            switch (args[0]) {
                case "rl": 
                case "reload": {
                    try {
                        Main.getConfigurationManager().reload();
                        sender.sendMessage("The configuration file has been reloaded.");
                    }
                    catch (Exception e) {
                        sender.sendMessage(ChatColor.RED + "An error occured while trying to reload the configuration files, probably because of a YAML syntax error.");
                        sender.sendMessage("Error: " + e.getMessage());
                        sender.sendMessage("For a more detailed error message see the console.");
                        e.printStackTrace();
                        return true;
                    }
                    Main.server.stop();
                    Main.server.start();
                    Server.clear();
                    sender.sendMessage("Run " + ChatColor.GRAY + "/ssx reloadcommands" + ChatColor.RESET + " to reload commands.");
                    return true;
                }
                case "reloadcommands": 
                case "rlcmd": {
                    Commands.registerCustomCommands();
                    sender.sendMessage("Re-registered custom commands.");
                    sender.sendMessage("Commands are not unregistered, if you disabled or renamed a command the old command will still work until the server is restarted.");
                    return true;
                }
                case "status": {
                    FileConfiguration configApi = Main.getConfigurationManager().getApiConfiguration();
                    sender.sendMessage("Using port " + configApi.getInt("port"));
                    sender.sendMessage("Listening on " + configApi.getString("host", "127.0.0.1 (no host specified in config)"));
                    if (Server.getServers().isEmpty()) {
                        sender.sendMessage("No data has been received from servers.");
                        return true;
                    }
                    for (Server server : ServerSelectorX.getServers()) {
                        String lastInfo;
                        long ms = server.getTimeSinceLastMessage();
                        String string = lastInfo = ms < 999999L ? server.getTimeSinceLastMessage() + "ms" : "\u221e ms";
                        if (server.isOnline()) {
                            List placeholderKeys = server.getPlaceholders().stream().map(Placeholder::getKey).collect(Collectors.toList());
                            sender.sendMessage(server.getName() + ": " + ChatColor.GREEN + "ONLINE (" + lastInfo + ") " + ChatColor.WHITE + ": " + ChatColor.GRAY + placeholderKeys.stream().map(s -> "{" + s + "}").collect(Collectors.joining(", ")));
                            continue;
                        }
                        sender.sendMessage(server.getName() + ": " + ChatColor.RED + "OFFLINE (" + lastInfo + ")");
                    }
                    return true;
                }
                case "items": {
                    Main.getConfigurationManager().listItemConfigurations().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "menus": {
                    Main.getConfigurationManager().listMenuConfigurations().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "commands": {
                    Main.getConfigurationManager().listCommandConfigurations().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "itemdebug": {
                    Main.ITEM_DEBUG = true;
                    sender.sendMessage("Debug messages related to items on join are now enabled until the next server restart/reload.");
                    return true;
                }
                case "sync": {
                    sender.sendMessage("Synchronising configuration files.. For more information have a look at the console.");
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getPlugin(), () -> Main.getConfigSync().sync());
                    return true;
                }
                case "synclist": {
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.getPlugin(), () -> Main.getConfigSync().getFilesToSync().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0)));
                    return true;
                }
            }
        }
        return false;
    }
}

