/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.http;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.grizzly.http.Method;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.HttpHandler;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Request;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Response;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.HttpStatus;

public class GetFile
extends HttpHandler {
    @Override
    public void service(Request request, Response response) throws Exception {
        Preconditions.checkArgument((request.getMethod() == Method.GET ? 1 : 0) != 0, (Object)"Must use GET method");
        request.getParameters().setEncoding(StandardCharsets.UTF_8);
        FileConfiguration api = Main.getConfigurationManager().getApiConfiguration();
        if (!api.getBoolean("files-api")) {
            response.getWriter().write("Files API disabled\n");
            response.setStatus(HttpStatus.FORBIDDEN_403);
            return;
        }
        String filePath = request.getParameter("file");
        if (filePath == null) {
            response.getWriter().write("File not specified\n");
            response.setStatus(HttpStatus.BAD_REQUEST_400);
            return;
        }
        Path file = Path.of(filePath, new String[0]);
        String type = Files.probeContentType(file);
        response.setContentType(type != null ? type : "application/octet-stream");
        Files.copy(file, response.getOutputStream());
    }
}

