/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.derkutils;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;

public class FileUtils {
    @NotNull
    public static String getFileName(@NotNull File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public static void appendStringToFile(@NotNull File file, @NotNull String string) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file, true));){
            writer.append(string);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyOutOfJar(@NotNull Class<?> clazz, @NotNull String pathToFileInJar, @NotNull File outputFile) throws IOException {
        Objects.requireNonNull(clazz, "Class is null");
        Objects.requireNonNull(pathToFileInJar, "File path is null");
        Objects.requireNonNull(outputFile, "Output file is null");
        if (!outputFile.exists()) {
            URL inputUrl = clazz.getResource(pathToFileInJar);
            try (InputStream in = inputUrl.openStream();){
                Files.copy(in, outputFile.toPath(), new CopyOption[0]);
            }
        }
    }

    public static void copyOutOfJar(@NotNull Class<?> clazz, @NotNull String pathToFileInJar, @NotNull Path outputFile) throws IOException {
        Objects.requireNonNull(clazz, "Class is null");
        Objects.requireNonNull(pathToFileInJar, "File path is null");
        Objects.requireNonNull(outputFile, "Output file is null");
        if (!Files.exists(outputFile, new LinkOption[0])) {
            URL inputUrl = clazz.getResource(pathToFileInJar);
            try (InputStream in = inputUrl.openStream();){
                Files.copy(in, outputFile, new CopyOption[0]);
            }
        }
    }
}

