/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.derkutils.bukkit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;

public class PlaceholderUtil {
    private static Method papiParseString = null;
    private static Method papiParseList = null;

    @NotNull
    public static String parsePlaceholders(@NotNull String string, Placeholder ... placeholders) {
        Objects.requireNonNull(string, "input string must not be null");
        Objects.requireNonNull(placeholders, "placeholders varargs is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        return string;
    }

    @NotNull
    public static String parsePlaceholders(@NotNull String string, @NotNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(string, "input string must not be null");
        Objects.requireNonNull(placeholders, "placeholders collection is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        return string;
    }

    @NotNull
    public static List<String> parsePlaceholders(@NotNull List<String> strings, Placeholder ... placeholders) {
        Objects.requireNonNull(strings, "strings list is null");
        Objects.requireNonNull(placeholders, "placeholders array is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "a placeholder is null").parse(strings);
        }
        return strings;
    }

    @NotNull
    public static List<String> parsePlaceholders(@NotNull List<String> strings, @NotNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(strings, "strings list is null");
        Objects.requireNonNull(placeholders, "placeholders collection is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "a placeholder is null").parse(strings);
        }
        return strings;
    }

    @NotNull
    public static String parsePapiPlaceholders(@NotNull Player player, @NotNull String string, Placeholder ... placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Input string must not be null");
        Objects.requireNonNull(placeholders, "Placeholders varargs is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        string = PlaceholderUtil.parsePapiPlaceholders(player, string);
        return string;
    }

    @NotNull
    public static String parsePapiPlaceholders(@NotNull Player player, @NotNull String string, @NotNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Input string must not be null");
        Objects.requireNonNull(placeholders, "Placeholders collection is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        string = PlaceholderUtil.parsePapiPlaceholders(player, string);
        return string;
    }

    @NotNull
    public static List<String> parsePapiPlaceholders(@NotNull Player player, @NotNull List<String> strings, Placeholder ... placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(placeholders, "Placeholders array is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "A placeholder is null").parse(strings);
        }
        strings = PlaceholderUtil.parsePapiPlaceholders(player, strings);
        return strings;
    }

    @NotNull
    public static List<String> parsePapiPlaceholders(@NotNull Player player, @NotNull List<String> strings, @NotNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(placeholders, "Placeholders collection is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "A placeholder is null").parse(strings);
        }
        strings = PlaceholderUtil.parsePapiPlaceholders(player, strings);
        return strings;
    }

    @NotNull
    public static String parsePapiPlaceholders(@NotNull Player player, @NotNull String string) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Provided string must not be null");
        if (papiParseString == null) {
            return string;
        }
        try {
            return (String)papiParseString.invoke(null, player, string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return string;
        }
    }

    @NotNull
    public static List<String> parsePapiPlaceholders(@NotNull Player player, @NotNull List<String> strings) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(strings, "Provided string list must not be null");
        if (papiParseList == null) {
            return strings;
        }
        try {
            return (List)papiParseList.invoke(null, player, strings);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return strings;
        }
    }

    static {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                Class<?> c = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                papiParseString = c.getMethod("setPlaceholders", Player.class, String.class);
                papiParseList = c.getMethod("setPlaceholders", Player.class, List.class);
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Placeholder {
        @NotNull
        private final String key;
        @NotNull
        private final String value;

        public Placeholder(@NotNull String key, @NotNull String value) {
            this.key = Objects.requireNonNull(key, "Placeholder key is null");
            this.value = Objects.requireNonNull(value, "Placeholder value is null");
        }

        @NotNull
        public String parse(@NotNull String string) {
            return string.replace(this.key, this.value);
        }

        @NotNull
        public List<String> parse(@NotNull List<String> list) {
            return list.stream().map(this::parse).collect(Collectors.toList());
        }
    }
}

