/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.compression.lzma.impl.rangecoder;

import java.io.IOException;
import xyz.derkades.serverselectorx.lib.grizzly.Buffer;
import xyz.derkades.serverselectorx.lib.grizzly.compression.lzma.LZMADecoder;

public class RangeDecoder {
    static final int kTopMask = -16777216;
    static final int kNumBitModelTotalBits = 11;
    static final int kBitModelTotal = 2048;
    static final int kNumMoveBits = 5;
    int Range;
    int Code;
    Buffer inputBuffer;
    int newBound;
    int decodeBitState;
    int decodeDirectBitsState;
    int decodeDirectBitsResult;
    int decodeDirectBitsI;

    public final void initFromState(LZMADecoder.LZMAInputState decoderState) {
        this.inputBuffer = decoderState.getSrc();
    }

    public final void releaseBuffer() {
        this.inputBuffer = null;
    }

    public final void init() throws IOException {
        this.Code = 0;
        this.Range = -1;
        this.decodeBitState = 0;
        this.decodeDirectBitsState = 0;
        for (int i = 0; i < 5; ++i) {
            this.Code = this.Code << 8 | this.inputBuffer.get() & 0xFF;
        }
    }

    public final boolean decodeDirectBits(LZMADecoder.LZMAInputState decodeState, int numTotalBits) throws IOException {
        block7: while (true) {
            switch (this.decodeDirectBitsState) {
                case 0: {
                    this.decodeDirectBitsResult = 0;
                    this.decodeDirectBitsI = numTotalBits;
                    this.decodeDirectBitsState = 1;
                }
                case 1: {
                    if (this.decodeDirectBitsI == 0) {
                        this.decodeDirectBitsState = 4;
                        continue block7;
                    }
                    this.Range >>>= 1;
                    int t = this.Code - this.Range >>> 31;
                    this.Code -= this.Range & t - 1;
                    this.decodeDirectBitsResult = this.decodeDirectBitsResult << 1 | 1 - t;
                    boolean condition = (this.Range & 0xFF000000) == 0;
                    this.decodeDirectBitsState = condition ? 2 : 3;
                    continue block7;
                }
                case 2: {
                    if (!this.inputBuffer.hasRemaining()) {
                        return false;
                    }
                    this.Code = this.Code << 8 | this.inputBuffer.get() & 0xFF;
                    this.Range <<= 8;
                }
                case 3: {
                    --this.decodeDirectBitsI;
                    this.decodeDirectBitsState = 1;
                    continue block7;
                }
                case 4: {
                    decodeState.lastMethodResult = this.decodeDirectBitsResult;
                    this.decodeDirectBitsState = 0;
                    return true;
                }
            }
        }
    }

    public boolean decodeBit(LZMADecoder.LZMAInputState decodeState, short[] probs, int index) throws IOException {
        block9: while (true) {
            switch (this.decodeBitState) {
                case 0: {
                    short prob = probs[index];
                    this.newBound = (this.Range >>> 11) * prob;
                    boolean condition = (this.Code ^ Integer.MIN_VALUE) < (this.newBound ^ Integer.MIN_VALUE);
                    this.decodeBitState = condition ? 1 : 4;
                    continue block9;
                }
                case 1: {
                    short prob = probs[index];
                    this.Range = this.newBound;
                    probs[index] = (short)(prob + (2048 - prob >>> 5));
                    boolean condition = (this.Range & 0xFF000000) == 0;
                    this.decodeBitState = condition ? 2 : 3;
                    continue block9;
                }
                case 2: {
                    if (!this.inputBuffer.hasRemaining()) {
                        return false;
                    }
                    this.Code = this.Code << 8 | this.inputBuffer.get() & 0xFF;
                    this.Range <<= 8;
                }
                case 3: {
                    decodeState.lastMethodResult = 0;
                    this.decodeBitState = 0;
                    return true;
                }
                case 4: {
                    short prob = probs[index];
                    this.Range -= this.newBound;
                    this.Code -= this.newBound;
                    probs[index] = (short)(prob - (prob >>> 5));
                    boolean condition = (this.Range & 0xFF000000) == 0;
                    this.decodeBitState = condition ? 5 : 6;
                    continue block9;
                }
                case 5: {
                    if (!this.inputBuffer.hasRemaining()) {
                        return false;
                    }
                    this.Code = this.Code << 8 | this.inputBuffer.get() & 0xFF;
                    this.Range <<= 8;
                }
                case 6: {
                    decodeState.lastMethodResult = 1;
                    this.decodeBitState = 0;
                    return true;
                }
            }
        }
    }

    public static void initBitModels(short[] probs) {
        for (int i = 0; i < probs.length; ++i) {
            probs[i] = 1024;
        }
    }
}

