/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.filterchain;

import java.io.IOException;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.Filter;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.FilterChainContext;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.FilterExecutor;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.NextAction;

abstract class ExecutorResolver {
    public static final FilterExecutor UPSTREAM_EXECUTOR_SAMPLE = new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    public static final FilterExecutor DOWNSTREAM_EXECUTOR_SAMPLE = new DownstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    private static final FilterExecutor CONNECT_EXECUTOR = new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleConnect(context);
        }
    };
    private static final FilterExecutor CLOSE_EXECUTOR = new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleClose(context);
        }
    };
    private static final FilterExecutor EVENT_UPSTREAM_EXECUTOR = new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleEvent(context, context.event);
        }
    };
    private static final FilterExecutor EVENT_DOWNSTREAM_EXECUTOR = new DownstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleEvent(context, context.event);
        }
    };
    private static final FilterExecutor ACCEPT_EXECUTOR = new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleAccept(context);
        }
    };
    private static final FilterExecutor WRITE_EXECUTOR = new DownstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleWrite(context);
        }
    };
    private static final FilterExecutor READ_EXECUTOR = new UpstreamExecutor(){

        @Override
        public NextAction execute(Filter filter, FilterChainContext context) throws IOException {
            return filter.handleRead(context);
        }
    };

    ExecutorResolver() {
    }

    public static FilterExecutor resolve(FilterChainContext context) {
        switch (context.getOperation()) {
            case READ: {
                return READ_EXECUTOR;
            }
            case WRITE: {
                return WRITE_EXECUTOR;
            }
            case ACCEPT: {
                return ACCEPT_EXECUTOR;
            }
            case CLOSE: {
                return CLOSE_EXECUTOR;
            }
            case CONNECT: {
                return CONNECT_EXECUTOR;
            }
            case EVENT: {
                return context.getFilterIdx() == Integer.MIN_VALUE || context.getStartIdx() <= context.getEndIdx() ? EVENT_UPSTREAM_EXECUTOR : EVENT_DOWNSTREAM_EXECUTOR;
            }
        }
        return null;
    }

    public static abstract class DownstreamExecutor
    implements FilterExecutor {
        @Override
        public final int defaultStartIdx(FilterChainContext context) {
            if (context.getFilterIdx() != Integer.MIN_VALUE) {
                return context.getFilterIdx();
            }
            int idx = context.getFilterChain().size() - 1;
            context.setFilterIdx(idx);
            return idx;
        }

        @Override
        public final int defaultEndIdx(FilterChainContext context) {
            return -1;
        }

        @Override
        public final int getNextFilter(FilterChainContext context) {
            return context.getFilterIdx() - 1;
        }

        @Override
        public final int getPreviousFilter(FilterChainContext context) {
            return context.getFilterIdx() + 1;
        }

        @Override
        public final boolean hasNextFilter(FilterChainContext context, int idx) {
            return idx > 0;
        }

        @Override
        public final boolean hasPreviousFilter(FilterChainContext context, int idx) {
            return idx < context.getFilterChain().size() - 1;
        }

        @Override
        public final void initIndexes(FilterChainContext context) {
            int startIdx = this.defaultStartIdx(context);
            context.setStartIdx(startIdx);
            context.setFilterIdx(startIdx);
            context.setEndIdx(this.defaultEndIdx(context));
        }

        @Override
        public final boolean isUpstream() {
            return false;
        }

        @Override
        public final boolean isDownstream() {
            return true;
        }
    }

    public static abstract class UpstreamExecutor
    implements FilterExecutor {
        @Override
        public final int defaultStartIdx(FilterChainContext context) {
            if (context.getFilterIdx() != Integer.MIN_VALUE) {
                return context.getFilterIdx();
            }
            context.setFilterIdx(0);
            return 0;
        }

        @Override
        public final int defaultEndIdx(FilterChainContext context) {
            return context.getFilterChain().size();
        }

        @Override
        public final int getNextFilter(FilterChainContext context) {
            return context.getFilterIdx() + 1;
        }

        @Override
        public final int getPreviousFilter(FilterChainContext context) {
            return context.getFilterIdx() - 1;
        }

        @Override
        public final boolean hasNextFilter(FilterChainContext context, int idx) {
            return idx < context.getFilterChain().size() - 1;
        }

        @Override
        public final boolean hasPreviousFilter(FilterChainContext context, int idx) {
            return idx > 0;
        }

        @Override
        public final void initIndexes(FilterChainContext context) {
            int startIdx = this.defaultStartIdx(context);
            context.setStartIdx(startIdx);
            context.setFilterIdx(startIdx);
            context.setEndIdx(this.defaultEndIdx(context));
        }

        @Override
        public final boolean isUpstream() {
            return true;
        }

        @Override
        public final boolean isDownstream() {
            return false;
        }
    }
}

