/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http;

import xyz.derkades.serverselectorx.lib.grizzly.Buffer;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.FilterChainContext;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpCodecFilter;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpContent;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpHeader;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpPacketParsing;
import xyz.derkades.serverselectorx.lib.grizzly.http.ParsingResult;
import xyz.derkades.serverselectorx.lib.grizzly.http.TransferEncoding;

public final class FixedLengthTransferEncoding
implements TransferEncoding {
    @Override
    public boolean wantDecode(HttpHeader httpPacket) {
        long contentLength = httpPacket.getContentLength();
        return contentLength != -1L;
    }

    @Override
    public boolean wantEncode(HttpHeader httpPacket) {
        long contentLength = httpPacket.getContentLength();
        return contentLength != -1L;
    }

    @Override
    public void prepareSerialize(FilterChainContext ctx, HttpHeader httpHeader, HttpContent httpContent) {
        int defaultContentLength = httpContent != null ? httpContent.getContent().remaining() : -1;
        httpHeader.makeContentLengthHeader(defaultContentLength);
    }

    @Override
    public ParsingResult parsePacket(FilterChainContext ctx, HttpHeader httpPacket, Buffer input) {
        HttpPacketParsing httpPacketParsing = (HttpPacketParsing)((Object)httpPacket);
        HttpCodecFilter.ContentParsingState contentParsingState = httpPacketParsing.getContentParsingState();
        if (contentParsingState.chunkRemainder == -1L) {
            contentParsingState.chunkRemainder = httpPacket.getContentLength();
        }
        Buffer remainder = null;
        long thisPacketRemaining = contentParsingState.chunkRemainder;
        int available = input.remaining();
        if ((long)available > thisPacketRemaining) {
            remainder = input.slice((int)((long)input.position() + thisPacketRemaining), input.limit());
            input.limit((int)((long)input.position() + thisPacketRemaining));
        }
        contentParsingState.chunkRemainder -= (long)input.remaining();
        boolean isLast = contentParsingState.chunkRemainder == 0L;
        return ParsingResult.create(((HttpContent.Builder)((HttpContent.Builder)httpPacket.httpContentBuilder().content(input)).last(isLast)).build(), remainder);
    }

    @Override
    public Buffer serializePacket(FilterChainContext ctx, HttpContent httpContent) {
        return httpContent.getContent();
    }
}

