/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.memory;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.memory.DefaultMemoryManagerFactory;
import xyz.derkades.serverselectorx.lib.grizzly.memory.HeapMemoryManager;
import xyz.derkades.serverselectorx.lib.grizzly.memory.MemoryManager;

class MemoryManagerInitializer {
    private static final String DMM_PROP_NAME = "xyz.derkades.serverselectorx.lib.grizzly.DEFAULT_MEMORY_MANAGER";
    private static final Logger LOGGER = Grizzly.logger(MemoryManagerInitializer.class);

    MemoryManagerInitializer() {
    }

    static MemoryManager initManager() {
        MemoryManager mm = MemoryManagerInitializer.initMemoryManagerViaFactory();
        return mm != null ? mm : MemoryManagerInitializer.initMemoryManagerFallback();
    }

    private static MemoryManager initMemoryManagerViaFactory() {
        DefaultMemoryManagerFactory mmf;
        String dmmfClassName = System.getProperty("xyz.derkades.serverselectorx.lib.grizzly.MEMORY_MANAGER_FACTORY");
        if (dmmfClassName != null && (mmf = (DefaultMemoryManagerFactory)MemoryManagerInitializer.newInstance(dmmfClassName)) != null) {
            return mmf.createMemoryManager();
        }
        return null;
    }

    private static MemoryManager initMemoryManagerFallback() {
        String className = System.getProperty(DMM_PROP_NAME);
        MemoryManager mm = (MemoryManager)MemoryManagerInitializer.newInstance(className);
        return mm != null ? mm : new HeapMemoryManager();
    }

    private static <T> T newInstance(String className) {
        if (className == null) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className, true, MemoryManager.class.getClassLoader());
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Unable to load or create a new instance of Class {0}.  Cause: {1}", new Object[]{className, e.getMessage()});
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.toString(), e);
            }
            return null;
        }
    }
}

