/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.monitoring;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;

public class MonitoringUtils {
    private static final Logger LOGGER = Grizzly.logger(MonitoringUtils.class);

    public static Object loadJmxObject(String jmxObjectClassname, Object constructorParam) {
        return MonitoringUtils.loadJmxObject(jmxObjectClassname, constructorParam, constructorParam.getClass());
    }

    public static Object loadJmxObject(String jmxObjectClassname, Object constructorParam, Class contructorParamType) {
        try {
            Class<?> clazz = MonitoringUtils.loadClass(jmxObjectClassname);
            Constructor<?> c = clazz.getDeclaredConstructor(contructorParamType);
            return c.newInstance(constructorParam);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Can not load JMX Object: " + jmxObjectClassname, e);
            return null;
        }
    }

    private static Class<?> loadClass(String classname) throws ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = MonitoringUtils.class.getClassLoader();
        }
        return classLoader.loadClass(classname);
    }
}

