/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.nio.transport;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.AbstractSocketConnectorHandler;
import xyz.derkades.serverselectorx.lib.grizzly.CompletionHandler;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.Context;
import xyz.derkades.serverselectorx.lib.grizzly.EmptyCompletionHandler;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.IOEvent;
import xyz.derkades.serverselectorx.lib.grizzly.IOEventLifeCycleListener;
import xyz.derkades.serverselectorx.lib.grizzly.impl.FutureImpl;
import xyz.derkades.serverselectorx.lib.grizzly.impl.ReadyFutureImpl;
import xyz.derkades.serverselectorx.lib.grizzly.nio.NIOChannelDistributor;
import xyz.derkades.serverselectorx.lib.grizzly.nio.NIOConnection;
import xyz.derkades.serverselectorx.lib.grizzly.nio.RegisterChannelResult;
import xyz.derkades.serverselectorx.lib.grizzly.nio.SelectionKeyHandler;
import xyz.derkades.serverselectorx.lib.grizzly.nio.transport.TCPNIOConnection;
import xyz.derkades.serverselectorx.lib.grizzly.nio.transport.TCPNIOTransport;
import xyz.derkades.serverselectorx.lib.grizzly.utils.Exceptions;
import xyz.derkades.serverselectorx.lib.grizzly.utils.Futures;

public class TCPNIOConnectorHandler
extends AbstractSocketConnectorHandler {
    private static final Logger LOGGER = Grizzly.logger(TCPNIOConnectorHandler.class);
    protected static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    private final InstantConnectHandler instantConnectHandler;
    protected boolean isReuseAddress;
    protected volatile long connectionTimeoutMillis = 30000L;

    protected TCPNIOConnectorHandler(TCPNIOTransport transport) {
        super(transport);
        this.connectionTimeoutMillis = transport.getConnectionTimeout();
        this.isReuseAddress = transport.isReuseAddress();
        this.instantConnectHandler = new InstantConnectHandler();
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        if (!this.transport.isBlocking()) {
            this.connectAsync(remoteAddress, localAddress, completionHandler, false);
        } else {
            this.connectSync(remoteAddress, localAddress, completionHandler);
        }
    }

    protected void connectSync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        FutureImpl<Connection> future = this.connectAsync(remoteAddress, localAddress, completionHandler, true);
        this.waitNIOFuture(future, completionHandler);
    }

    @Override
    protected FutureImpl<Connection> connectAsync(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler, boolean needFuture) {
        TCPNIOTransport nioTransport = (TCPNIOTransport)this.transport;
        NIOConnection newConnection = null;
        try {
            CompletionHandler<Connection> completionHandlerToPass;
            FutureImpl<Connection> futureToReturn;
            SocketChannel socketChannel = nioTransport.getSelectorProvider().openSocketChannel();
            NIOConnection finalConnection = newConnection = nioTransport.obtainNIOConnection(socketChannel);
            Socket socket = socketChannel.socket();
            nioTransport.getChannelConfigurator().preConfigure(nioTransport, socketChannel);
            boolean reuseAddr = this.isReuseAddress;
            if (reuseAddr != nioTransport.isReuseAddress()) {
                socket.setReuseAddress(reuseAddr);
            }
            if (localAddress != null) {
                socket.bind(localAddress);
            }
            this.preConfigure(finalConnection);
            finalConnection.setProcessor(this.getProcessor());
            finalConnection.setProcessorSelector(this.getProcessorSelector());
            boolean isConnected = socketChannel.connect(remoteAddress);
            if (needFuture) {
                futureToReturn = this.makeCancellableFuture(finalConnection);
                completionHandlerToPass = Futures.toCompletionHandler(futureToReturn, completionHandler);
            } else {
                completionHandlerToPass = completionHandler;
                futureToReturn = null;
            }
            ((TCPNIOConnection)newConnection).setConnectResultHandler(new TCPNIOConnection.ConnectResultHandler((TCPNIOConnection)finalConnection, completionHandlerToPass){
                final /* synthetic */ TCPNIOConnection val$finalConnection;
                final /* synthetic */ CompletionHandler val$completionHandlerToPass;
                {
                    this.val$finalConnection = tCPNIOConnection;
                    this.val$completionHandlerToPass = completionHandler;
                }

                @Override
                public void connected() throws IOException {
                    TCPNIOConnectorHandler.onConnectedAsync(this.val$finalConnection, this.val$completionHandlerToPass);
                }

                @Override
                public void failed(Throwable throwable) {
                    TCPNIOConnectorHandler.abortConnection(this.val$finalConnection, this.val$completionHandlerToPass, throwable);
                }
            });
            NIOChannelDistributor nioChannelDistributor = nioTransport.getNIOChannelDistributor();
            if (nioChannelDistributor == null) {
                throw new IllegalStateException("NIOChannelDistributor is null. Is Transport running?");
            }
            if (isConnected) {
                nioChannelDistributor.registerChannelAsync(socketChannel, 0, newConnection, this.instantConnectHandler);
            } else {
                nioChannelDistributor.registerChannelAsync(socketChannel, 8, newConnection, new RegisterChannelCompletionHandler((TCPNIOConnection)newConnection));
            }
            return futureToReturn;
        }
        catch (Exception e) {
            if (newConnection != null) {
                newConnection.closeSilently();
            }
            if (completionHandler != null) {
                completionHandler.failed(e);
            }
            return needFuture ? ReadyFutureImpl.create(e) : null;
        }
    }

    protected static void onConnectedAsync(TCPNIOConnection connection, CompletionHandler<Connection> completionHandler) throws IOException {
        TCPNIOTransport tcpTransport = (TCPNIOTransport)connection.getTransport();
        SocketChannel channel = (SocketChannel)connection.getChannel();
        try {
            if (!channel.isConnected()) {
                channel.finishConnect();
            }
            connection.resetProperties();
            connection.disableIOEvent(IOEvent.CLIENT_CONNECTED);
            tcpTransport.getChannelConfigurator().postConfigure(tcpTransport, channel);
        }
        catch (Exception e) {
            TCPNIOConnectorHandler.abortConnection(connection, completionHandler, e);
            throw Exceptions.makeIOException(e);
        }
        if (connection.notifyReady()) {
            tcpTransport.fireIOEvent(IOEvent.CONNECTED, connection, new EnableReadHandler(completionHandler));
        }
    }

    public boolean isReuseAddress() {
        return this.isReuseAddress;
    }

    public void setReuseAddress(boolean isReuseAddress) {
        this.isReuseAddress = isReuseAddress;
    }

    public long getSyncConnectTimeout(TimeUnit timeUnit) {
        return timeUnit.convert(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
    }

    public void setSyncConnectTimeout(long timeout, TimeUnit timeUnit) {
        this.connectionTimeoutMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    protected void waitNIOFuture(FutureImpl<Connection> future, CompletionHandler<Connection> completionHandler) {
        try {
            future.get(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Futures.notifyFailure(future, completionHandler, e);
        }
        catch (TimeoutException e) {
            Futures.notifyFailure(future, completionHandler, new IOException("Channel registration on Selector timeout!"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void abortConnection(TCPNIOConnection connection, CompletionHandler<Connection> completionHandler, Throwable failure) {
        connection.closeSilently();
        if (completionHandler != null) {
            completionHandler.failed(failure);
        }
    }

    public static Builder builder(TCPNIOTransport transport) {
        return new Builder().setTransport(transport);
    }

    public static class Builder
    extends AbstractSocketConnectorHandler.Builder<Builder> {
        private TCPNIOTransport transport;
        private Boolean reuseAddress;
        private Long timeout;
        private TimeUnit timeoutTimeunit;

        @Override
        public TCPNIOConnectorHandler build() {
            TCPNIOConnectorHandler handler = (TCPNIOConnectorHandler)super.build();
            if (this.reuseAddress != null) {
                handler.setReuseAddress(this.reuseAddress);
            }
            if (this.timeout != null) {
                handler.setSyncConnectTimeout(this.timeout, this.timeoutTimeunit);
            }
            return handler;
        }

        public Builder setTransport(TCPNIOTransport transport) {
            this.transport = transport;
            return this;
        }

        public Builder setReuseAddress(boolean reuseAddress) {
            this.reuseAddress = reuseAddress;
            return this;
        }

        public Builder setSyncConnectTimeout(long timeout, TimeUnit timeunit) {
            this.timeout = timeout;
            this.timeoutTimeunit = timeunit;
            return this;
        }

        @Override
        protected AbstractSocketConnectorHandler create() {
            if (this.transport == null) {
                throw new IllegalStateException("Unable to create TCPNIOConnectorHandler - transport is null");
            }
            return new TCPNIOConnectorHandler(this.transport);
        }
    }

    private static final class EnableReadHandler
    extends IOEventLifeCycleListener.Adapter {
        private final CompletionHandler<Connection> completionHandler;

        private EnableReadHandler(CompletionHandler<Connection> completionHandler) {
            this.completionHandler = completionHandler;
        }

        @Override
        public void onReregister(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onNotRun(Context context) throws IOException {
            this.onComplete(context, null);
        }

        @Override
        public void onComplete(Context context, Object data) throws IOException {
            TCPNIOConnection connection = (TCPNIOConnection)context.getConnection();
            if (this.completionHandler != null) {
                this.completionHandler.completed(connection);
            }
            if (!connection.isStandalone()) {
                connection.enableInitialOpRead();
            }
        }

        @Override
        public void onError(Context context, Object description) throws IOException {
            context.getConnection().closeSilently();
        }
    }

    private static class RegisterChannelCompletionHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private final TCPNIOConnection connection;

        public RegisterChannelCompletionHandler(TCPNIOConnection connection) {
            this.connection = connection;
        }

        @Override
        public void completed(RegisterChannelResult result) {
            TCPNIOTransport transport = (TCPNIOTransport)this.connection.getTransport();
            transport.selectorRegistrationHandler.completed(result);
        }

        @Override
        public void failed(Throwable throwable) {
            this.connection.checkConnectFailed(throwable);
        }
    }

    private class InstantConnectHandler
    extends EmptyCompletionHandler<RegisterChannelResult> {
        private InstantConnectHandler() {
        }

        @Override
        public void completed(RegisterChannelResult result) {
            TCPNIOTransport transport = (TCPNIOTransport)TCPNIOConnectorHandler.this.transport;
            transport.selectorRegistrationHandler.completed(result);
            SelectionKey selectionKey = result.getSelectionKey();
            SelectionKeyHandler selectionKeyHandler = transport.getSelectionKeyHandler();
            TCPNIOConnection connection = (TCPNIOConnection)selectionKeyHandler.getConnectionForKey(selectionKey);
            try {
                connection.onConnect();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Exception happened, when trying to connect the channel", e);
            }
        }
    }
}

