/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.streams;

import xyz.derkades.serverselectorx.lib.grizzly.TransformationException;
import xyz.derkades.serverselectorx.lib.grizzly.TransformationResult;
import xyz.derkades.serverselectorx.lib.grizzly.Transformer;
import xyz.derkades.serverselectorx.lib.grizzly.streams.Stream;
import xyz.derkades.serverselectorx.lib.grizzly.streams.StreamReader;
import xyz.derkades.serverselectorx.lib.grizzly.utils.ResultAware;
import xyz.derkades.serverselectorx.lib.grizzly.utils.conditions.Condition;

public class StreamDecodeCondition<E>
implements Condition {
    private final StreamReader streamReader;
    private final Transformer<Stream, E> decoder;
    private final ResultAware<E> resultAware;

    public StreamDecodeCondition(StreamReader streamReader, Transformer<Stream, E> decoder, ResultAware<E> resultAware) {
        this.streamReader = streamReader;
        this.decoder = decoder;
        this.resultAware = resultAware;
    }

    @Override
    public boolean check() {
        TransformationResult<Stream, E> result = this.decoder.transform(this.streamReader.getConnection(), this.streamReader);
        TransformationResult.Status status = result.getStatus();
        if (status == TransformationResult.Status.COMPLETE) {
            this.resultAware.setResult(result.getMessage());
            return true;
        }
        if (status == TransformationResult.Status.INCOMPLETE) {
            return false;
        }
        throw new TransformationException(result.getErrorCode() + ": " + result.getErrorDescription());
    }
}

