/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.NotNull;
import xyz.derkades.serverselectorx.lib.jetbrains-annotations.Nullable;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.Component;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.ContextImpl;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.MiniMessage;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.MiniMessageParser;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.MiniMessageSerializer;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.internal.serializer.SerializableResolver;
import xyz.derkades.serverselectorx.lib.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import xyz.derkades.serverselectorx.lib.kyori.adventure.util.Services;

final class MiniMessageImpl
implements MiniMessage {
    private static final Optional<MiniMessage.Provider> SERVICE = Services.service(MiniMessage.Provider.class);
    static final Consumer<MiniMessage.Builder> BUILDER = SERVICE.map(MiniMessage.Provider::builder).orElseGet(() -> builder -> {});
    static final UnaryOperator<Component> DEFAULT_COMPACTING_METHOD = Component::compact;
    private final boolean strict;
    @Nullable
    private final Consumer<String> debugOutput;
    private final UnaryOperator<Component> postProcessor;
    final MiniMessageParser parser;

    MiniMessageImpl(@NotNull TagResolver resolver, boolean strict, @Nullable Consumer<String> debugOutput, @NotNull UnaryOperator<Component> postProcessor) {
        this.parser = new MiniMessageParser(resolver);
        this.strict = strict;
        this.debugOutput = debugOutput;
        this.postProcessor = postProcessor;
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String input) {
        return this.parser.parseFormat(input, this.newContext(input, null));
    }

    @Override
    @NotNull
    public Component deserialize(@NotNull String input, @NotNull TagResolver tagResolver) {
        return this.parser.parseFormat(input, this.newContext(input, Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    @Override
    public  @NotNull Node.Root deserializeToTree(@NotNull String input) {
        return this.parser.parseToTree(input, this.newContext(input, null));
    }

    @Override
    public  @NotNull Node.Root deserializeToTree(@NotNull String input, @NotNull TagResolver tagResolver) {
        return this.parser.parseToTree(input, this.newContext(input, Objects.requireNonNull(tagResolver, "tagResolver")));
    }

    @Override
    @NotNull
    public String serialize(@NotNull Component component) {
        return MiniMessageSerializer.serialize(component, this.serialResolver(null), this.strict);
    }

    private SerializableResolver serialResolver(@Nullable TagResolver extraResolver) {
        if (extraResolver == null) {
            if (this.parser.tagResolver instanceof SerializableResolver) {
                return (SerializableResolver)((Object)this.parser.tagResolver);
            }
        } else {
            TagResolver combined = TagResolver.resolver(this.parser.tagResolver, extraResolver);
            if (combined instanceof SerializableResolver) {
                return (SerializableResolver)((Object)combined);
            }
        }
        return (SerializableResolver)((Object)TagResolver.empty());
    }

    @Override
    @NotNull
    public String escapeTags(@NotNull String input) {
        return this.parser.escapeTokens(input, this.newContext(input, null));
    }

    @Override
    @NotNull
    public String escapeTags(@NotNull String input, @NotNull TagResolver tagResolver) {
        return this.parser.escapeTokens(input, this.newContext(input, tagResolver));
    }

    @Override
    @NotNull
    public String stripTags(@NotNull String input) {
        return this.parser.stripTokens(input, this.newContext(input, null));
    }

    @Override
    @NotNull
    public String stripTags(@NotNull String input, @NotNull TagResolver tagResolver) {
        return this.parser.stripTokens(input, this.newContext(input, tagResolver));
    }

    @NotNull
    private ContextImpl newContext(@NotNull String input, @Nullable TagResolver resolver) {
        Objects.requireNonNull(input, "input");
        if (resolver == null) {
            return ContextImpl.of(this.strict, this.debugOutput, input, this, TagResolver.empty(), this.postProcessor);
        }
        return ContextImpl.of(this.strict, this.debugOutput, input, this, resolver, this.postProcessor);
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static final class BuilderImpl
    implements MiniMessage.Builder {
        private TagResolver tagResolver = TagResolver.standard();
        private boolean strict = false;
        private Consumer<String> debug = null;
        private UnaryOperator<Component> postProcessor = DEFAULT_COMPACTING_METHOD;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(MiniMessageImpl serializer) {
            this();
            this.tagResolver = serializer.parser.tagResolver;
            this.strict = serializer.strict;
            this.debug = serializer.debugOutput;
            this.postProcessor = serializer.postProcessor;
        }

        @Override
        @NotNull
        public MiniMessage.Builder tags(@NotNull TagResolver tags) {
            this.tagResolver = Objects.requireNonNull(tags, "tags");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder editTags(@NotNull Consumer<TagResolver.Builder> adder) {
            Objects.requireNonNull(adder, "adder");
            TagResolver.Builder builder = TagResolver.builder().resolver(this.tagResolver);
            adder.accept(builder);
            this.tagResolver = builder.build();
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder debug(@Nullable Consumer<String> debugOutput) {
            this.debug = debugOutput;
            return this;
        }

        @Override
        @NotNull
        public MiniMessage.Builder postProcessor(@NotNull UnaryOperator<Component> postProcessor) {
            this.postProcessor = Objects.requireNonNull(postProcessor, "postProcessor");
            return this;
        }

        @Override
        @NotNull
        public MiniMessage build() {
            return new MiniMessageImpl(this.tagResolver, this.strict, this.debug, this.postProcessor);
        }
    }

    static final class Instances {
        static final MiniMessage INSTANCE = MiniMessageImpl.access$000().map(MiniMessage.Provider::miniMessage).orElseGet(() -> new MiniMessageImpl(TagResolver.standard(), false, null, DEFAULT_COMPACTING_METHOD));

        Instances() {
        }
    }
}

